<?php
session_start();

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: index.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../classes/Kuafor.php';

// Veritabanı bağlantısı
$db = Database::getInstance();
$kuafor = new Kuafor();

// İstatistikleri al
$stats = $kuafor->getDashboardStats();

// Son kuaförler
$son_kuaforler = $kuafor->getList(['limit' => 5]);

// Son iletişim formları
$sql = "SELECT * FROM iletisim_formlari ORDER BY created_at DESC LIMIT 5";
$stmt = $db->query($sql);
$son_iletisim = $stmt ? $stmt->fetchAll() : [];

// Destek talepleri
$sql = "SELECT COUNT(*) as toplam FROM destek_talepleri WHERE durum = 'acik'";
$stmt = $db->query($sql);
$acik_destek = $stmt ? $stmt->fetchColumn() : 0;

// Bu ayki yeni kuaförler
$sql = "SELECT COUNT(*) as aylik FROM kuaforler WHERE DATE(created_at) >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)";
$stmt = $db->query($sql);
$aylik_kuafor = $stmt ? $stmt->fetchColumn() : 0;

// Bu ayki randevular
$sql = "SELECT COUNT(*) as aylik FROM randevular WHERE DATE(created_at) >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)";
$stmt = $db->query($sql);
$aylik_randevu = $stmt ? $stmt->fetchColumn() : 0;
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Super Admin Dashboard - Kuaför Sistemi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .sidebar-active {
            background: rgba(59, 130, 246, 0.1);
            border-right: 3px solid #3b82f6;
        }
        
        .stat-card {
            transition: all 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body class="bg-gray-100">
    <!-- Sidebar -->
    <div class="fixed inset-y-0 left-0 w-64 bg-white shadow-lg z-50">
        <!-- Logo -->
        <div class="flex items-center justify-center h-16 bg-blue-600">
            <div class="flex items-center">
                <i class="fas fa-user-shield text-white text-2xl mr-3"></i>
                <span class="text-white text-xl font-bold">Super Admin</span>
            </div>
        </div>
        
        <!-- Navigation -->
        <nav class="mt-8">
            <a href="dashboard.php" class="sidebar-active flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-tachometer-alt mr-3"></i>
                Dashboard
            </a>
            <a href="kuaforler.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-store mr-3"></i>
                Kuaförler
                <span class="ml-auto bg-blue-100 text-blue-800 text-xs px-2 py-1 rounded-full"><?php echo $stats['toplam_kuafor']; ?></span>
            </a>
            <a href="yeni-kuafor.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-plus-circle mr-3"></i>
                Yeni Kuaför
            </a>
            <a href="iletisim-formlari.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-envelope mr-3"></i>
                İletişim Formları
                <span class="ml-auto bg-green-100 text-green-800 text-xs px-2 py-1 rounded-full"><?php echo count($son_iletisim); ?></span>
            </a>
            <a href="destek.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-headset mr-3"></i>
                Destek Talepleri
                <?php if ($acik_destek > 0): ?>
                <span class="ml-auto bg-red-100 text-red-800 text-xs px-2 py-1 rounded-full"><?php echo $acik_destek; ?></span>
                <?php endif; ?>
            </a>
            <a href="ayarlar.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-cog mr-3"></i>
                Sistem Ayarları
            </a>
            <hr class="my-4 mx-6">
            <a href="logout.php" class="flex items-center px-6 py-3 text-red-600 hover:bg-red-50">
                <i class="fas fa-sign-out-alt mr-3"></i>
                Çıkış Yap
            </a>
        </nav>
    </div>
    
    <!-- Main Content -->
    <div class="ml-64 min-h-screen">
        <!-- Header -->
        <header class="bg-white shadow-sm border-b">
            <div class="flex items-center justify-between px-6 py-4">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Dashboard</h1>
                    <p class="text-gray-600">Kuaför Sistemi Genel Bakış</p>
                </div>
                <div class="flex items-center space-x-4">
                    <div class="text-right">
                        <p class="text-sm text-gray-600">Hoş geldin,</p>
                        <p class="font-semibold text-gray-800"><?php echo htmlspecialchars($_SESSION['admin_username']); ?></p>
                    </div>
                    <div class="w-10 h-10 bg-blue-600 rounded-full flex items-center justify-center">
                        <i class="fas fa-user text-white"></i>
                    </div>
                </div>
            </div>
        </header>
        
        <!-- Stats Cards -->
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                <!-- Toplam Kuaför -->
                <div class="stat-card bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-store text-blue-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm text-gray-600">Toplam Kuaför</p>
                            <p class="text-2xl font-bold text-gray-800"><?php echo $stats['toplam_kuafor']; ?></p>
                        </div>
                    </div>
                    <div class="mt-4">
                        <span class="text-green-600 text-sm">
                            <i class="fas fa-arrow-up"></i> +<?php echo $aylik_kuafor; ?> bu ay
                        </span>
                    </div>
                </div>
                
                <!-- Aktif Kuaför -->
                <div class="stat-card bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-check-circle text-green-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm text-gray-600">Aktif Kuaför</p>
                            <p class="text-2xl font-bold text-gray-800"><?php echo $stats['aktif_kuafor']; ?></p>
                        </div>
                    </div>
                    <div class="mt-4">
                        <span class="text-blue-600 text-sm">
                            %<?php echo $stats['toplam_kuafor'] > 0 ? round(($stats['aktif_kuafor'] / $stats['toplam_kuafor']) * 100) : 0; ?> aktiflik oranı
                        </span>
                    </div>
                </div>
                
                <!-- Toplam Randevu -->
                <div class="stat-card bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-calendar-check text-purple-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm text-gray-600">Toplam Randevu</p>
                            <p class="text-2xl font-bold text-gray-800"><?php echo $stats['toplam_randevu']; ?></p>
                        </div>
                    </div>
                    <div class="mt-4">
                        <span class="text-green-600 text-sm">
                            <i class="fas fa-arrow-up"></i> +<?php echo $aylik_randevu; ?> bu ay
                        </span>
                    </div>
                </div>
                
                <!-- Destek Talepleri -->
                <div class="stat-card bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-headset text-orange-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm text-gray-600">Açık Destek</p>
                            <p class="text-2xl font-bold text-gray-800"><?php echo $acik_destek; ?></p>
                        </div>
                    </div>
                    <div class="mt-4">
                        <?php if ($acik_destek > 0): ?>
                            <span class="text-red-600 text-sm">
                                <i class="fas fa-exclamation-triangle"></i> Dikkat gerekiyor
                            </span>
                        <?php else: ?>
                            <span class="text-green-600 text-sm">
                                <i class="fas fa-check"></i> Hepsi çözüldü
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Charts and Tables -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Son Kuaförler -->
                <div class="bg-white rounded-lg shadow">
                    <div class="p-6 border-b">
                        <h3 class="text-lg font-semibold text-gray-800">Son Eklenen Kuaförler</h3>
                    </div>
                    <div class="p-6">
                        <?php if (empty($son_kuaforler)): ?>
                            <p class="text-gray-500 text-center py-8">Henüz kuaför eklenmemiş</p>
                        <?php else: ?>
                            <div class="space-y-4">
                                <?php foreach ($son_kuaforler as $k): ?>
                                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                                        <div class="flex items-center">
                                            <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                                                <i class="fas fa-store text-blue-600"></i>
                                            </div>
                                            <div class="ml-3">
                                                <p class="font-medium text-gray-800"><?php echo htmlspecialchars($k['isletme_adi']); ?></p>
                                                <p class="text-sm text-gray-600"><?php echo htmlspecialchars($k['sehir']); ?></p>
                                            </div>
                                        </div>
                                        <div class="text-right">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                <?php echo $k['durum'] === 'aktif' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'; ?>">
                                                <?php echo ucfirst($k['durum']); ?>
                                            </span>
                                            <p class="text-xs text-gray-500 mt-1">
                                                <?php echo date('d.m.Y', strtotime($k['created_at'])); ?>
                                            </p>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="mt-4 text-center">
                                <a href="kuaforler.php" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                    Tümünü Gör <i class="fas fa-arrow-right ml-1"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Son İletişim Formları -->
                <div class="bg-white rounded-lg shadow">
                    <div class="p-6 border-b">
                        <h3 class="text-lg font-semibold text-gray-800">Son İletişim Formları</h3>
                    </div>
                    <div class="p-6">
                        <?php if (empty($son_iletisim)): ?>
                            <p class="text-gray-500 text-center py-8">Henüz form gönderilmemiş</p>
                        <?php else: ?>
                            <div class="space-y-4">
                                <?php foreach ($son_iletisim as $form): ?>
                                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                                        <div class="flex items-center">
                                            <div class="w-10 h-10 bg-green-100 rounded-full flex items-center justify-center">
                                                <i class="fas fa-envelope text-green-600"></i>
                                            </div>
                                            <div class="ml-3">
                                                <p class="font-medium text-gray-800"><?php echo htmlspecialchars($form['ad_soyad']); ?></p>
                                                <p class="text-sm text-gray-600"><?php echo htmlspecialchars($form['email']); ?></p>
                                            </div>
                                        </div>
                                        <div class="text-right">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                <?php 
                                                    switch($form['durum']) {
                                                        case 'yeni': echo 'bg-blue-100 text-blue-800'; break;
                                                        case 'okundu': echo 'bg-yellow-100 text-yellow-800'; break;
                                                        case 'cevaplandi': echo 'bg-green-100 text-green-800'; break;
                                                    }
                                                ?>">
                                                <?php echo ucfirst($form['durum']); ?>
                                            </span>
                                            <p class="text-xs text-gray-500 mt-1">
                                                <?php echo date('d.m.Y', strtotime($form['created_at'])); ?>
                                            </p>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="mt-4 text-center">
                                <a href="iletisim-formlari.php" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                    Tümünü Gör <i class="fas fa-arrow-right ml-1"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="mt-8 bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Hızlı İşlemler</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <a href="yeni-kuafor.php" class="flex items-center p-4 bg-blue-50 rounded-lg hover:bg-blue-100 transition duration-200">
                        <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center">
                            <i class="fas fa-plus text-white"></i>
                        </div>
                        <div class="ml-4">
                            <p class="font-medium text-gray-800">Yeni Kuaför Ekle</p>
                            <p class="text-sm text-gray-600">Sisteme yeni kuaför kaydı</p>
                        </div>
                    </a>
                    
                    <a href="../database/install.php" target="_blank" class="flex items-center p-4 bg-green-50 rounded-lg hover:bg-green-100 transition duration-200">
                        <div class="w-12 h-12 bg-green-600 rounded-lg flex items-center justify-center">
                            <i class="fas fa-database text-white"></i>
                        </div>
                        <div class="ml-4">
                            <p class="font-medium text-gray-800">Veritabanı Kurulum</p>
                            <p class="text-sm text-gray-600">Sistem kurulumunu kontrol et</p>
                        </div>
                    </a>
                    
                    <a href="ayarlar.php" class="flex items-center p-4 bg-purple-50 rounded-lg hover:bg-purple-100 transition duration-200">
                        <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center">
                            <i class="fas fa-cog text-white"></i>
                        </div>
                        <div class="ml-4">
                            <p class="font-medium text-gray-800">Sistem Ayarları</p>
                            <p class="text-sm text-gray-600">Genel sistem konfigürasyonu</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Sayfa yüklendiğinde animasyonlar
        document.addEventListener('DOMContentLoaded', function() {
            // Stat kartlarını animasyonla göster
            const statCards = document.querySelectorAll('.stat-card');
            statCards.forEach((card, index) => {
                setTimeout(() => {
                    card.style.opacity = '0';
                    card.style.transform = 'translateY(20px)';
                    card.style.transition = 'all 0.5s ease';
                    
                    setTimeout(() => {
                        card.style.opacity = '1';
                        card.style.transform = 'translateY(0)';
                    }, 100);
                }, index * 100);
            });
        });
        
        // Otomatik yenileme (5 dakikada bir)
        setTimeout(() => {
            location.reload();
        }, 300000);
    </script>
</body>
</html>
