<?php
session_start();

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: index.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';

$db = Database::getInstance();
$success = '';
$error = '';

// Şifre değiştirme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_password'])) {
    $current_password = trim($_POST['current_password'] ?? '');
    $new_password = trim($_POST['new_password'] ?? '');
    $confirm_password = trim($_POST['confirm_password'] ?? '');
    
    // Mevcut şifre kontrolü
    $admin_password = 'Kuafor2025!'; // Gerçek projede veritabanından alınmalı
    
    if ($current_password !== $admin_password) {
        $error = 'Mevcut şifre hatalı!';
    } elseif (strlen($new_password) < 6) {
        $error = 'Yeni şifre en az 6 karakter olmalıdır!';
    } elseif ($new_password !== $confirm_password) {
        $error = 'Yeni şifreler eşleşmiyor!';
    } else {
        // Şifre değiştirme işlemi burada yapılacak
        // Gerçek projede veritabanında admin tablosu olmalı
        $success = 'Şifre başarıyla değiştirildi! (Demo modunda gerçek değişiklik yapılmaz)';
    }
}

// Sistem ayarları güncelleme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_settings'])) {
    $site_baslik = trim($_POST['site_baslik'] ?? '');
    $site_alt_baslik = trim($_POST['site_alt_baslik'] ?? '');
    $ana_renk = trim($_POST['ana_renk'] ?? '');
    
    try {
        // Ana site ayarlarını güncelle
        $settings = [
            'site_baslik' => $site_baslik,
            'site_alt_baslik' => $site_alt_baslik,
            'ana_renk' => $ana_renk
        ];
        
        foreach ($settings as $key => $value) {
            $sql = "UPDATE ana_site_ayarlari SET ayar_degeri = ? WHERE ayar_adi = ?";
            $stmt = $db->prepare($sql);
            $stmt->execute([$value, $key]);
        }
        
        $success = 'Sistem ayarları başarıyla güncellendi!';
        
    } catch (Exception $e) {
        $error = 'Ayarlar güncellenirken hata oluştu: ' . $e->getMessage();
    }
}

// Mevcut ayarları al
$sql = "SELECT * FROM ana_site_ayarlari";
$stmt = $db->query($sql);
$ayarlar_raw = $stmt ? $stmt->fetchAll() : [];

$ayarlar = [];
foreach ($ayarlar_raw as $ayar) {
    $ayarlar[$ayar['ayar_adi']] = $ayar['ayar_degeri'];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Ayarları - Super Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .sidebar-active {
            background: rgba(59, 130, 246, 0.1);
            border-right: 3px solid #3b82f6;
        }
    </style>
</head>
<body class="bg-gray-100">
    <!-- Sidebar -->
    <div class="fixed inset-y-0 left-0 w-64 bg-white shadow-lg z-50">
        <!-- Logo -->
        <div class="flex items-center justify-center h-16 bg-blue-600">
            <div class="flex items-center">
                <i class="fas fa-user-shield text-white text-2xl mr-3"></i>
                <span class="text-white text-xl font-bold">Super Admin</span>
            </div>
        </div>
        
        <!-- Navigation -->
        <nav class="mt-8">
            <a href="dashboard.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-tachometer-alt mr-3"></i>
                Dashboard
            </a>
            <a href="kuaforler.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-store mr-3"></i>
                Kuaförler
            </a>
            <a href="yeni-kuafor.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-plus-circle mr-3"></i>
                Yeni Kuaför
            </a>
            <a href="iletisim-formlari.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-envelope mr-3"></i>
                İletişim Formları
            </a>
            <a href="destek.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-headset mr-3"></i>
                Destek Talepleri
            </a>
            <a href="ayarlar.php" class="sidebar-active flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-cog mr-3"></i>
                Sistem Ayarları
            </a>
            <hr class="my-4 mx-6">
            <a href="logout.php" class="flex items-center px-6 py-3 text-red-600 hover:bg-red-50">
                <i class="fas fa-sign-out-alt mr-3"></i>
                Çıkış Yap
            </a>
        </nav>
    </div>
    
    <!-- Main Content -->
    <div class="ml-64 min-h-screen">
        <!-- Header -->
        <header class="bg-white shadow-sm border-b">
            <div class="flex items-center justify-between px-6 py-4">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Sistem Ayarları</h1>
                    <p class="text-gray-600">Sistem konfigürasyonu ve güvenlik ayarları</p>
                </div>
                <div class="flex items-center space-x-4">
                    <div class="text-right">
                        <p class="text-sm text-gray-600">Hoş geldin,</p>
                        <p class="font-semibold text-gray-800"><?php echo htmlspecialchars($_SESSION['admin_username']); ?></p>
                    </div>
                    <div class="w-10 h-10 bg-blue-600 rounded-full flex items-center justify-center">
                        <i class="fas fa-user text-white"></i>
                    </div>
                </div>
            </div>
        </header>
        
        <!-- Content -->
        <div class="p-6">
            <!-- Bildirimler -->
            <?php if ($success): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle mr-2"></i>
                        <?php echo htmlspecialchars($success); ?>
                    </div>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        <?php echo htmlspecialchars($error); ?>
                    </div>
                </div>
            <?php endif; ?>
            
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Şifre Değiştirme -->
                <div class="bg-white rounded-lg shadow p-6">
                    <div class="flex items-center mb-6">
                        <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-key text-red-600 text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800">Şifre Değiştir</h3>
                            <p class="text-gray-600">Super admin şifrenizi güvenli bir şekilde değiştirin</p>
                        </div>
                    </div>
                    
                    <form method="POST" class="space-y-4">
                        <div>
                            <label for="current_password" class="block text-sm font-medium text-gray-700 mb-2">
                                Mevcut Şifre
                            </label>
                            <input type="password" 
                                   id="current_password" 
                                   name="current_password" 
                                   required 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                   placeholder="Mevcut şifrenizi girin">
                        </div>
                        
                        <div>
                            <label for="new_password" class="block text-sm font-medium text-gray-700 mb-2">
                                Yeni Şifre
                            </label>
                            <input type="password" 
                                   id="new_password" 
                                   name="new_password" 
                                   required 
                                   minlength="6"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                   placeholder="En az 6 karakter">
                        </div>
                        
                        <div>
                            <label for="confirm_password" class="block text-sm font-medium text-gray-700 mb-2">
                                Yeni Şifre (Tekrar)
                            </label>
                            <input type="password" 
                                   id="confirm_password" 
                                   name="confirm_password" 
                                   required 
                                   minlength="6"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                   placeholder="Yeni şifrenizi tekrar girin">
                        </div>
                        
                        <button type="submit" 
                                name="change_password"
                                class="w-full bg-red-600 text-white py-2 px-4 rounded-lg hover:bg-red-700 transition duration-300">
                            <i class="fas fa-key mr-2"></i>Şifre Değiştir
                        </button>
                    </form>
                </div>
                
                <!-- Sistem Ayarları -->
                <div class="bg-white rounded-lg shadow p-6">
                    <div class="flex items-center mb-6">
                        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-cog text-blue-600 text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800">Ana Site Ayarları</h3>
                            <p class="text-gray-600">Tanıtım sitesi genel ayarları</p>
                        </div>
                    </div>
                    
                    <form method="POST" class="space-y-4">
                        <div>
                            <label for="site_baslik" class="block text-sm font-medium text-gray-700 mb-2">
                                Site Başlığı
                            </label>
                            <input type="text" 
                                   id="site_baslik" 
                                   name="site_baslik" 
                                   required 
                                   value="<?php echo htmlspecialchars($ayarlar['site_baslik'] ?? ''); ?>"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <div>
                            <label for="site_alt_baslik" class="block text-sm font-medium text-gray-700 mb-2">
                                Site Alt Başlığı
                            </label>
                            <textarea id="site_alt_baslik" 
                                      name="site_alt_baslik" 
                                      rows="3"
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo htmlspecialchars($ayarlar['site_alt_baslik'] ?? ''); ?></textarea>
                        </div>
                        
                        <div>
                            <label for="ana_renk" class="block text-sm font-medium text-gray-700 mb-2">
                                Ana Renk Teması
                            </label>
                            <select id="ana_renk" 
                                    name="ana_renk" 
                                    class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="mavi-turuncu" <?php echo ($ayarlar['ana_renk'] ?? '') === 'mavi-turuncu' ? 'selected' : ''; ?>>Mavi-Turuncu</option>
                                <option value="mor-pembe" <?php echo ($ayarlar['ana_renk'] ?? '') === 'mor-pembe' ? 'selected' : ''; ?>>Mor-Pembe</option>
                                <option value="yesil-mavi" <?php echo ($ayarlar['ana_renk'] ?? '') === 'yesil-mavi' ? 'selected' : ''; ?>>Yeşil-Mavi</option>
                                <option value="kirmizi-turuncu" <?php echo ($ayarlar['ana_renk'] ?? '') === 'kirmizi-turuncu' ? 'selected' : ''; ?>>Kırmızı-Turuncu</option>
                            </select>
                        </div>
                        
                        <button type="submit" 
                                name="update_settings"
                                class="w-full bg-blue-600 text-white py-2 px-4 rounded-lg hover:bg-blue-700 transition duration-300">
                            <i class="fas fa-save mr-2"></i>Ayarları Kaydet
                        </button>
                    </form>
                </div>
            </div>
            
            <!-- Sistem Bilgileri -->
            <div class="mt-6 bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Sistem Bilgileri</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <i class="fas fa-server text-3xl text-blue-600 mb-2"></i>
                        <h4 class="font-semibold text-gray-800">PHP Versiyonu</h4>
                        <p class="text-gray-600"><?php echo PHP_VERSION; ?></p>
                    </div>
                    
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <i class="fas fa-database text-3xl text-green-600 mb-2"></i>
                        <h4 class="font-semibold text-gray-800">MySQL Versiyonu</h4>
                        <p class="text-gray-600">
                            <?php 
                            try {
                                $version = $db->query("SELECT VERSION()")->fetchColumn();
                                echo explode('-', $version)[0];
                            } catch (Exception $e) {
                                echo 'Bilinmiyor';
                            }
                            ?>
                        </p>
                    </div>
                    
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <i class="fas fa-clock text-3xl text-purple-600 mb-2"></i>
                        <h4 class="font-semibold text-gray-800">Son Giriş</h4>
                        <p class="text-gray-600"><?php echo date('d.m.Y H:i', $_SESSION['login_time']); ?></p>
                    </div>
                </div>
            </div>
            
            <!-- Güvenlik Uyarıları -->
            <div class="mt-6 bg-yellow-50 border border-yellow-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-yellow-800 mb-4">
                    <i class="fas fa-exclamation-triangle mr-2"></i>Güvenlik Önerileri
                </h3>
                <ul class="space-y-2 text-yellow-700">
                    <li><i class="fas fa-check mr-2"></i>Şifrenizi düzenli olarak değiştirin</li>
                    <li><i class="fas fa-check mr-2"></i>Güçlü şifre kullanın (en az 8 karakter, büyük/küçük harf, rakam)</li>
                    <li><i class="fas fa-check mr-2"></i>Admin paneline sadece güvenli ağlardan erişin</li>
                    <li><i class="fas fa-check mr-2"></i>Sistem güncellemelerini takip edin</li>
                </ul>
            </div>
        </div>
    </div>
    
    <script>
        // Şifre eşleşme kontrolü
        document.getElementById('confirm_password').addEventListener('input', function() {
            const newPassword = document.getElementById('new_password').value;
            const confirmPassword = this.value;
            
            if (newPassword !== confirmPassword) {
                this.setCustomValidity('Şifreler eşleşmiyor');
            } else {
                this.setCustomValidity('');
            }
        });
        
        // Form gönderme onayı
        document.querySelector('form').addEventListener('submit', function(e) {
            if (e.submitter.name === 'change_password') {
                if (!confirm('Şifrenizi değiştirmek istediğinizden emin misiniz?')) {
                    e.preventDefault();
                }
            }
        });
    </script>
</body>
</html>
