<?php
echo "PHP çalışıyor! ✅<br>";
echo "PHP Versiyonu: " . PHP_VERSION . "<br>";
echo "Tarih: " . date('Y-m-d H:i:s') . "<br>";

// Database test
echo "<br>Database test:<br>";
try {
    require_once __DIR__ . '/config/database.php';
    $db = Database::getInstance();
    echo "✅ Database bağlantısı başarılı!<br>";
    
    // Tablo kontrolü
    $tables = $db->getConnection()->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    echo "✅ Tablolar: " . count($tables) . " adet<br>";
    
} catch (Exception $e) {
    echo "❌ Database hatası: " . $e->getMessage() . "<br>";
}

echo "<br>Dosya yolları:<br>";
echo "Current dir: " . __DIR__ . "<br>";
echo "Config exists: " . (file_exists(__DIR__ . '/config/database.php') ? 'YES' : 'NO') . "<br>";
echo "Classes exists: " . (file_exists(__DIR__ . '/classes/Kuafor.php') ? 'YES' : 'NO') . "<br>";
?>
