<?php
// Kuaför Ana Sayfası Template
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../classes/Kuafor.php';

// Subdomain'i al
$subdomain = $_GET['subdomain'] ?? '';
$page = $_GET['page'] ?? '';

if (empty($subdomain)) {
    // Ana domain'e yönlendir
    header('Location: /kuafor-sistem/');
    exit;
}

// Kuaför bilgilerini al
$kuafor_class = new Kuafor();
$kuafor = $kuafor_class->getBySubdomain($subdomain);

if (!$kuafor) {
    http_response_code(404);
    echo "Kuaför bulunamadı!";
    exit;
}

// Sayfa yönlendirmeleri
switch($page) {
    case 'randevu':
        include __DIR__ . '/randevu.php';
        exit;
    case 'hakkimizda':
        include __DIR__ . '/hakkimizda.php';
        exit;
    case 'hizmetler':
        include __DIR__ . '/hizmetler.php';
        exit;
    case 'galeri':
        include __DIR__ . '/galeri.php';
        exit;
    case 'iletisim':
        include __DIR__ . '/iletisim.php';
        exit;
    case 'admin':
        include __DIR__ . '/admin/index.php';
        exit;
}

// Kuaför verilerini decode et
$sosyal_medya = json_decode($kuafor['sosyal_medya'], true) ?: [];
$calisma_saatleri = json_decode($kuafor['calisma_saatleri'], true) ?: [];

// Hizmetleri al
$db = Database::getInstance();
$sql = "SELECT * FROM hizmetler WHERE kuafor_id = ? AND durum = 'aktif' AND anasayfa_goster = 1 ORDER BY sira_no";
$stmt = $db->prepare($sql);
$stmt->execute([$kuafor['id']]);
$hizmetler = $stmt->fetchAll();

// Stilistleri al
$sql = "SELECT * FROM stilistler WHERE kuafor_id = ? AND durum = 'aktif' ORDER BY id";
$stmt = $db->prepare($sql);
$stmt->execute([$kuafor['id']]);
$stilistler = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($kuafor['isletme_adi']); ?> - <?php echo htmlspecialchars($kuafor['sehir']); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($kuafor['alt_yazi']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($kuafor['seo_keywords']); ?>">
    
    <!-- Open Graph -->
    <meta property="og:title" content="<?php echo htmlspecialchars($kuafor['isletme_adi']); ?>">
    <meta property="og:description" content="<?php echo htmlspecialchars($kuafor['alt_yazi']); ?>">
    <meta property="og:type" content="business.business">
    <meta property="og:url" content="https://<?php echo $subdomain; ?>.emrebaytas.com.tr">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom Styles -->
    <style>
        .hero-gradient {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .service-card {
            transition: all 0.3s ease;
        }
        
        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .floating {
            animation: floating 3s ease-in-out infinite;
        }
        
        @keyframes floating {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
        
        .theme-<?php echo $kuafor['tema_renk']; ?> {
            /* Tema renkleri dinamik olarak uygulanacak */
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <nav class="bg-white shadow-lg fixed w-full top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <h1 class="text-xl font-bold text-gray-800"><?php echo htmlspecialchars($kuafor['isletme_adi']); ?></h1>
                    </div>
                </div>
                
                <div class="hidden md:flex items-center space-x-8">
                    <a href="#anasayfa" class="text-gray-700 hover:text-blue-600 transition duration-300">Ana Sayfa</a>
                    <a href="#hakkimizda" class="text-gray-700 hover:text-blue-600 transition duration-300">Hakkımızda</a>
                    <a href="#hizmetler" class="text-gray-700 hover:text-blue-600 transition duration-300">Hizmetler</a>
                    <a href="#galeri" class="text-gray-700 hover:text-blue-600 transition duration-300">Galeri</a>
                    <a href="#iletisim" class="text-gray-700 hover:text-blue-600 transition duration-300">İletişim</a>
                    <a href="randevu" class="bg-blue-600 text-white px-6 py-2 rounded-full hover:bg-blue-700 transition duration-300">
                        <i class="fas fa-calendar-plus mr-2"></i>Randevu Al
                    </a>
                </div>
                
                <!-- Mobile menu button -->
                <div class="md:hidden flex items-center">
                    <button id="mobile-menu-btn" class="text-gray-700 hover:text-blue-600">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Mobile menu -->
        <div id="mobile-menu" class="md:hidden hidden bg-white border-t">
            <div class="px-2 pt-2 pb-3 space-y-1">
                <a href="#anasayfa" class="block px-3 py-2 text-gray-700">Ana Sayfa</a>
                <a href="#hakkimizda" class="block px-3 py-2 text-gray-700">Hakkımızda</a>
                <a href="#hizmetler" class="block px-3 py-2 text-gray-700">Hizmetler</a>
                <a href="#galeri" class="block px-3 py-2 text-gray-700">Galeri</a>
                <a href="#iletisim" class="block px-3 py-2 text-gray-700">İletişim</a>
                <a href="randevu" class="block px-3 py-2 bg-blue-600 text-white rounded-lg mx-3 text-center">
                    <i class="fas fa-calendar-plus mr-2"></i>Randevu Al
                </a>
            </div>
        </div>
    </nav>
    
    <!-- Hero Section -->
    <section id="anasayfa" class="hero-gradient pt-16 min-h-screen flex items-center">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div class="text-white">
                    <h1 class="text-4xl md:text-6xl font-bold mb-6 leading-tight">
                        <?php echo htmlspecialchars($kuafor['karsilama_yazisi']); ?>
                    </h1>
                    <p class="text-xl md:text-2xl mb-8 text-blue-100">
                        <?php echo htmlspecialchars($kuafor['alt_yazi']); ?>
                    </p>
                    <div class="flex flex-col sm:flex-row gap-4">
                        <a href="randevu" class="bg-white text-blue-600 px-8 py-4 rounded-full font-semibold hover:bg-blue-50 transition duration-300 text-center">
                            <i class="fas fa-calendar-plus mr-2"></i>Hemen Randevu Al
                        </a>
                        <a href="#hizmetler" class="border-2 border-white text-white px-8 py-4 rounded-full font-semibold hover:bg-white hover:text-blue-600 transition duration-300 text-center">
                            <i class="fas fa-cut mr-2"></i>Hizmetlerimizi İncele
                        </a>
                    </div>
                </div>
                
                <div class="floating">
                    <div class="bg-white bg-opacity-10 backdrop-blur-lg rounded-2xl p-8 border border-white border-opacity-20">
                        <h3 class="text-2xl font-bold text-white mb-6">Hızlı Randevu</h3>
                        <div class="space-y-4">
                            <div class="flex items-center text-white">
                                <i class="fas fa-phone mr-3 text-blue-200"></i>
                                <span><?php echo htmlspecialchars($kuafor['telefon']); ?></span>
                            </div>
                            <div class="flex items-center text-white">
                                <i class="fas fa-map-marker-alt mr-3 text-blue-200"></i>
                                <span><?php echo htmlspecialchars($kuafor['sehir'] . ', ' . $kuafor['ilce']); ?></span>
                            </div>
                            <div class="flex items-center text-white">
                                <i class="fas fa-clock mr-3 text-blue-200"></i>
                                <span>Pazartesi - Cumartesi: 09:00 - 18:00</span>
                            </div>
                        </div>
                        <a href="randevu" class="block w-full bg-blue-600 text-white text-center py-3 rounded-lg mt-6 hover:bg-blue-700 transition duration-300">
                            Online Randevu Al
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Hakkımızda Section -->
    <section id="hakkimizda" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-800 mb-4">Hakkımızda</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    <?php echo htmlspecialchars($kuafor['sehir']); ?>'de profesyonel kuaför hizmetleri sunuyoruz. 
                    Deneyimli ekibimiz ve modern ekipmanlarımızla size en iyi hizmeti vermeyi hedefliyoruz.
                </p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="text-center">
                    <div class="w-20 h-20 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-award text-3xl text-blue-600"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-800 mb-2">Profesyonel Ekip</h3>
                    <p class="text-gray-600">Deneyimli ve sertifikalı kuaförlerimizle kaliteli hizmet</p>
                </div>
                
                <div class="text-center">
                    <div class="w-20 h-20 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-clock text-3xl text-blue-600"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-800 mb-2">Esnek Saatler</h3>
                    <p class="text-gray-600">Size uygun saatlerde randevu imkanı</p>
                </div>
                
                <div class="text-center">
                    <div class="w-20 h-20 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-heart text-3xl text-blue-600"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-800 mb-2">Müşteri Memnuniyeti</h3>
                    <p class="text-gray-600">%100 müşteri memnuniyeti garantisi</p>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Hizmetler Section -->
    <section id="hizmetler" class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-800 mb-4">Hizmetlerimiz</h2>
                <p class="text-xl text-gray-600">Profesyonel kuaför hizmetlerimizi keşfedin</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <?php foreach ($hizmetler as $hizmet): ?>
                    <div class="service-card bg-white rounded-xl shadow-lg p-6 text-center">
                        <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-cut text-2xl text-blue-600"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">
                            <?php echo htmlspecialchars($hizmet['hizmet_adi']); ?>
                        </h3>
                        <p class="text-gray-600 mb-4">
                            <?php echo htmlspecialchars($hizmet['aciklama']); ?>
                        </p>
                        <div class="flex justify-between items-center">
                            <span class="text-2xl font-bold text-blue-600">
                                ₺<?php echo number_format($hizmet['fiyat'], 0); ?>
                            </span>
                            <span class="text-sm text-gray-500">
                                <?php echo $hizmet['sure_dakika']; ?> dk
                            </span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="text-center mt-12">
                <a href="randevu" class="bg-blue-600 text-white px-8 py-4 rounded-full font-semibold hover:bg-blue-700 transition duration-300">
                    <i class="fas fa-calendar-plus mr-2"></i>Randevu Al
                </a>
            </div>
        </div>
    </section>
    
    <!-- Stilistler Section -->
    <?php if (!empty($stilistler)): ?>
    <section id="stilistler" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-800 mb-4">Ekibimiz</h2>
                <p class="text-xl text-gray-600">Profesyonel stilistlerimizle tanışın</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php foreach ($stilistler as $stilist): ?>
                    <div class="text-center">
                        <div class="w-32 h-32 bg-gray-200 rounded-full mx-auto mb-4 flex items-center justify-center">
                            <?php if ($stilist['profil_resmi']): ?>
                                <img src="<?php echo htmlspecialchars($stilist['profil_resmi']); ?>" 
                                     alt="<?php echo htmlspecialchars($stilist['isim_soyisim']); ?>"
                                     class="w-full h-full rounded-full object-cover">
                            <?php else: ?>
                                <i class="fas fa-user text-4xl text-gray-400"></i>
                            <?php endif; ?>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">
                            <?php echo htmlspecialchars($stilist['isim_soyisim']); ?>
                        </h3>
                        <p class="text-blue-600 font-medium">
                            <?php echo htmlspecialchars($stilist['uzmanlik_alani']); ?>
                        </p>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
    
    <!-- İletişim Section -->
    <section id="iletisim" class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-800 mb-4">İletişim</h2>
                <p class="text-xl text-gray-600">Bize ulaşın, size yardımcı olalım</p>
            </div>
            
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
                <div>
                    <div class="space-y-6">
                        <div class="flex items-center">
                            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-map-marker-alt text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-800">Adres</h3>
                                <p class="text-gray-600"><?php echo htmlspecialchars($kuafor['adres']); ?></p>
                                <p class="text-gray-600"><?php echo htmlspecialchars($kuafor['sehir'] . ', ' . $kuafor['ilce']); ?></p>
                            </div>
                        </div>
                        
                        <div class="flex items-center">
                            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-phone text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-800">Telefon</h3>
                                <p class="text-gray-600"><?php echo htmlspecialchars($kuafor['telefon']); ?></p>
                            </div>
                        </div>
                        
                        <?php if ($kuafor['email']): ?>
                        <div class="flex items-center">
                            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-envelope text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-800">E-posta</h3>
                                <p class="text-gray-600"><?php echo htmlspecialchars($kuafor['email']); ?></p>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Çalışma Saatleri -->
                        <div class="bg-white rounded-lg p-6 shadow-lg">
                            <h3 class="font-semibold text-gray-800 mb-4">Çalışma Saatleri</h3>
                            <div class="space-y-2">
                                <?php 
                                $gunler = [
                                    'pazartesi' => 'Pazartesi',
                                    'sali' => 'Salı',
                                    'carsamba' => 'Çarşamba',
                                    'persembe' => 'Perşembe',
                                    'cuma' => 'Cuma',
                                    'cumartesi' => 'Cumartesi',
                                    'pazar' => 'Pazar'
                                ];
                                
                                foreach ($gunler as $key => $gun):
                                    $saat = $calisma_saatleri[$key] ?? ['aktif' => false];
                                ?>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600"><?php echo $gun; ?></span>
                                        <span class="text-gray-800">
                                            <?php if ($saat['aktif']): ?>
                                                <?php echo $saat['acilis'] . ' - ' . $saat['kapanis']; ?>
                                            <?php else: ?>
                                                Kapalı
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div>
                    <div class="bg-white rounded-lg shadow-lg p-8">
                        <h3 class="text-2xl font-semibold text-gray-800 mb-6">Randevu Al</h3>
                        <p class="text-gray-600 mb-6">
                            Online randevu sistemimizi kullanarak kolayca randevu alabilirsiniz.
                        </p>
                        <a href="randevu" class="block w-full bg-blue-600 text-white text-center py-4 rounded-lg font-semibold hover:bg-blue-700 transition duration-300">
                            <i class="fas fa-calendar-plus mr-2"></i>Randevu Sistemi
                        </a>
                        
                        <!-- Sosyal Medya -->
                        <?php if (!empty($sosyal_medya)): ?>
                        <div class="mt-8">
                            <h4 class="font-semibold text-gray-800 mb-4">Sosyal Medya</h4>
                            <div class="flex space-x-4">
                                <?php if (!empty($sosyal_medya['instagram'])): ?>
                                    <a href="<?php echo htmlspecialchars($sosyal_medya['instagram']); ?>" 
                                       target="_blank" 
                                       class="w-10 h-10 bg-pink-500 rounded-full flex items-center justify-center text-white hover:bg-pink-600 transition duration-300">
                                        <i class="fab fa-instagram"></i>
                                    </a>
                                <?php endif; ?>
                                
                                <?php if (!empty($sosyal_medya['facebook'])): ?>
                                    <a href="<?php echo htmlspecialchars($sosyal_medya['facebook']); ?>" 
                                       target="_blank" 
                                       class="w-10 h-10 bg-blue-500 rounded-full flex items-center justify-center text-white hover:bg-blue-600 transition duration-300">
                                        <i class="fab fa-facebook-f"></i>
                                    </a>
                                <?php endif; ?>
                                
                                <?php if (!empty($sosyal_medya['whatsapp'])): ?>
                                    <a href="<?php echo htmlspecialchars($sosyal_medya['whatsapp']); ?>" 
                                       target="_blank" 
                                       class="w-10 h-10 bg-green-500 rounded-full flex items-center justify-center text-white hover:bg-green-600 transition duration-300">
                                        <i class="fab fa-whatsapp"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div>
                    <h3 class="text-xl font-semibold mb-4"><?php echo htmlspecialchars($kuafor['isletme_adi']); ?></h3>
                    <p class="text-gray-300 mb-4"><?php echo htmlspecialchars($kuafor['alt_yazi']); ?></p>
                    <p class="text-gray-300"><?php echo htmlspecialchars($kuafor['adres']); ?></p>
                </div>
                
                <div>
                    <h3 class="text-xl font-semibold mb-4">Hızlı Linkler</h3>
                    <ul class="space-y-2">
                        <li><a href="#anasayfa" class="text-gray-300 hover:text-white transition duration-300">Ana Sayfa</a></li>
                        <li><a href="#hakkimizda" class="text-gray-300 hover:text-white transition duration-300">Hakkımızda</a></li>
                        <li><a href="#hizmetler" class="text-gray-300 hover:text-white transition duration-300">Hizmetler</a></li>
                        <li><a href="randevu" class="text-gray-300 hover:text-white transition duration-300">Randevu Al</a></li>
                    </ul>
                </div>
                
                <div>
                    <h3 class="text-xl font-semibold mb-4">İletişim</h3>
                    <div class="space-y-2">
                        <p class="text-gray-300">
                            <i class="fas fa-phone mr-2"></i><?php echo htmlspecialchars($kuafor['telefon']); ?>
                        </p>
                        <?php if ($kuafor['email']): ?>
                        <p class="text-gray-300">
                            <i class="fas fa-envelope mr-2"></i><?php echo htmlspecialchars($kuafor['email']); ?>
                        </p>
                        <?php endif; ?>
                        <p class="text-gray-300">
                            <i class="fas fa-map-marker-alt mr-2"></i><?php echo htmlspecialchars($kuafor['sehir'] . ', ' . $kuafor['ilce']); ?>
                        </p>
                    </div>
                </div>
            </div>
            
            <hr class="border-gray-700 my-8">
            
            <div class="flex flex-col md:flex-row justify-between items-center">
                <p class="text-gray-300">
                    © 2025 <?php echo htmlspecialchars($kuafor['isletme_adi']); ?>. Tüm hakları saklıdır.
                </p>
                <p class="text-gray-400 text-sm mt-2 md:mt-0">
                    <a href="https://emrebaytas.com.tr" target="_blank" class="hover:text-white transition duration-300">
                        Emre Baytaş
                    </a> tarafından geliştirilmiştir.
                </p>
            </div>
        </div>
    </footer>
    
    <!-- WhatsApp Float Button -->
    <?php if (!empty($sosyal_medya['whatsapp'])): ?>
    <a href="<?php echo htmlspecialchars($sosyal_medya['whatsapp']); ?>" 
       target="_blank" 
       class="fixed bottom-6 right-6 w-14 h-14 bg-green-500 rounded-full flex items-center justify-center text-white shadow-lg hover:bg-green-600 transition duration-300 z-40">
        <i class="fab fa-whatsapp text-2xl"></i>
    </a>
    <?php endif; ?>
    
    <!-- Scripts -->
    <script>
        // Mobile menu toggle
        document.getElementById('mobile-menu-btn').addEventListener('click', function() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        });
        
        // Smooth scrolling
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
        
        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('nav');
            if (window.scrollY > 100) {
                navbar.classList.add('bg-white', 'shadow-lg');
            } else {
                navbar.classList.remove('bg-white', 'shadow-lg');
            }
        });
    </script>
</body>
</html>
