<?php
session_start();

// Subdomain'i al
$subdomain = $_GET['subdomain'] ?? '';

if (empty($subdomain)) {
    header('Location: /kuafor-sistem/');
    exit;
}

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../classes/Kuafor.php';

// Kuaför bilgilerini al
$kuafor_class = new Kuafor();
$kuafor = $kuafor_class->getBySubdomain($subdomain);

if (!$kuafor) {
    http_response_code(404);
    echo "Kuaför bulunamadı!";
    exit;
}

// Zaten giriş yapmışsa dashboard'a yönlendir
if (isset($_SESSION['kuafor_admin_logged_in']) && 
    $_SESSION['kuafor_admin_logged_in'] === true && 
    $_SESSION['kuafor_id'] == $kuafor['id']) {
    header('Location: dashboard.php?subdomain=' . $subdomain);
    exit;
}

// Giriş işlemi
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');
    
    if ($username === $kuafor['admin_username'] && password_verify($password, $kuafor['admin_password'])) {
        $_SESSION['kuafor_admin_logged_in'] = true;
        $_SESSION['kuafor_id'] = $kuafor['id'];
        $_SESSION['kuafor_username'] = $username;
        $_SESSION['kuafor_name'] = $kuafor['isletme_adi'];
        $_SESSION['login_time'] = time();
        
        header('Location: dashboard.php?subdomain=' . $subdomain);
        exit;
    } else {
        $error = 'Kullanıcı adı veya şifre hatalı!';
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($kuafor['isletme_adi']); ?> - Admin Giriş</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .login-card {
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .floating {
            animation: floating 3s ease-in-out infinite;
        }
        
        @keyframes floating {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
    </style>
</head>
<body class="gradient-bg min-h-screen flex items-center justify-center">
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute -top-40 -right-40 w-80 h-80 bg-white opacity-10 rounded-full"></div>
        <div class="absolute -bottom-40 -left-40 w-80 h-80 bg-white opacity-10 rounded-full"></div>
    </div>
    
    <div class="relative z-10 w-full max-w-md">
        <!-- Logo ve Başlık -->
        <div class="text-center mb-8 floating">
            <div class="w-20 h-20 bg-white bg-opacity-20 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-store text-3xl text-white"></i>
            </div>
            <h1 class="text-3xl font-bold text-white mb-2"><?php echo htmlspecialchars($kuafor['isletme_adi']); ?></h1>
            <p class="text-white text-opacity-80">Admin Paneli Giriş</p>
        </div>
        
        <!-- Giriş Formu -->
        <div class="login-card rounded-2xl p-8 shadow-2xl">
            <?php if ($error): ?>
                <div class="bg-red-500 bg-opacity-20 border border-red-500 text-white px-4 py-3 rounded-lg mb-6">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        <?php echo htmlspecialchars($error); ?>
                    </div>
                </div>
            <?php endif; ?>
            
            <form method="POST" class="space-y-6">
                <div>
                    <label for="username" class="block text-white text-sm font-medium mb-2">
                        <i class="fas fa-user mr-2"></i>Kullanıcı Adı
                    </label>
                    <input type="text" 
                           id="username" 
                           name="username" 
                           required 
                           class="w-full px-4 py-3 bg-white bg-opacity-20 border border-white border-opacity-30 rounded-lg text-white placeholder-white placeholder-opacity-70 focus:outline-none focus:ring-2 focus:ring-white focus:ring-opacity-50"
                           placeholder="Kullanıcı adınızı girin"
                           value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>">
                </div>
                
                <div>
                    <label for="password" class="block text-white text-sm font-medium mb-2">
                        <i class="fas fa-lock mr-2"></i>Şifre
                    </label>
                    <div class="relative">
                        <input type="password" 
                               id="password" 
                               name="password" 
                               required 
                               class="w-full px-4 py-3 bg-white bg-opacity-20 border border-white border-opacity-30 rounded-lg text-white placeholder-white placeholder-opacity-70 focus:outline-none focus:ring-2 focus:ring-white focus:ring-opacity-50"
                               placeholder="Şifrenizi girin">
                        <button type="button" 
                                onclick="togglePassword()" 
                                class="absolute right-3 top-1/2 transform -translate-y-1/2 text-white text-opacity-70 hover:text-opacity-100">
                            <i id="passwordIcon" class="fas fa-eye"></i>
                        </button>
                    </div>
                </div>
                
                <div class="flex items-center justify-between">
                    <label class="flex items-center text-white text-sm">
                        <input type="checkbox" class="mr-2 rounded">
                        Beni Hatırla
                    </label>
                    <a href="#" class="text-white text-opacity-80 hover:text-opacity-100 text-sm">
                        Şifremi Unuttum?
                    </a>
                </div>
                
                <button type="submit" 
                        class="w-full bg-white bg-opacity-20 hover:bg-opacity-30 text-white font-semibold py-3 px-4 rounded-lg transition duration-300 border border-white border-opacity-30">
                    <i class="fas fa-sign-in-alt mr-2"></i>Admin Paneline Giriş
                </button>
            </form>
        </div>
        
        <!-- Ana Siteye Dön -->
        <div class="text-center mt-8">
            <a href="../?subdomain=<?php echo $subdomain; ?>" class="text-white text-opacity-80 hover:text-opacity-100 text-sm">
                <i class="fas fa-arrow-left mr-2"></i>Ana Siteye Dön
            </a>
        </div>
        
        <!-- Alt Bilgi -->
        <div class="text-center mt-8">
            <p class="text-white text-opacity-60 text-sm">
                © 2025 <?php echo htmlspecialchars($kuafor['isletme_adi']); ?> - 
                <a href="https://emrebaytas.com.tr" target="_blank" class="text-white hover:text-opacity-100">
                    Emre Baytaş
                </a>
            </p>
        </div>
        
        <!-- Güvenlik Uyarısı -->
        <div class="mt-6 bg-yellow-500 bg-opacity-20 border border-yellow-500 text-white px-4 py-3 rounded-lg">
            <div class="flex items-center text-sm">
                <i class="fas fa-shield-alt mr-2"></i>
                <span>Bu panel sadece yetkili personel içindir. Tüm işlemler loglanmaktadır.</span>
            </div>
        </div>
    </div>
    
    <script>
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const passwordIcon = document.getElementById('passwordIcon');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                passwordIcon.className = 'fas fa-eye-slash';
            } else {
                passwordInput.type = 'password';
                passwordIcon.className = 'fas fa-eye';
            }
        }
        
        // Otomatik odaklanma
        document.getElementById('username').focus();
        
        // Enter tuşu ile form gönderme
        document.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                document.querySelector('form').submit();
            }
        });
    </script>
</body>
</html>
