<?php
session_start();

// Subdomain'i al
$subdomain = $_GET['subdomain'] ?? '';

if (empty($subdomain)) {
    header('Location: /kuafor-sistem/');
    exit;
}

// Giriş kontrolü
if (!isset($_SESSION['kuafor_admin_logged_in']) || $_SESSION['kuafor_admin_logged_in'] !== true) {
    header('Location: index.php?subdomain=' . $subdomain);
    exit;
}

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../classes/Kuafor.php';

$db = Database::getInstance();
$kuafor_class = new Kuafor();
$kuafor = $kuafor_class->getById($_SESSION['kuafor_id']);

if (!$kuafor) {
    session_destroy();
    header('Location: index.php?subdomain=' . $subdomain);
    exit;
}

$success = '';
$error = '';

// Şifre değiştirme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_password'])) {
    $current_password = trim($_POST['current_password'] ?? '');
    $new_password = trim($_POST['new_password'] ?? '');
    $confirm_password = trim($_POST['confirm_password'] ?? '');
    
    if (!password_verify($current_password, $kuafor['admin_password'])) {
        $error = 'Mevcut şifre hatalı!';
    } elseif (strlen($new_password) < 6) {
        $error = 'Yeni şifre en az 6 karakter olmalıdır!';
    } elseif ($new_password !== $confirm_password) {
        $error = 'Yeni şifreler eşleşmiyor!';
    } else {
        try {
            // Şifreyi güncelle
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $sql = "UPDATE kuaforler SET admin_password = ? WHERE id = ?";
            $stmt = $db->prepare($sql);
            $result = $stmt->execute([$hashed_password, $kuafor['id']]);
            
            if ($result) {
                $success = 'Şifre başarıyla değiştirildi!';
                
                // Log kaydı
                $sql = "INSERT INTO sistem_loglari (kuafor_id, islem_tipi, aciklama, ip_adresi) VALUES (?, ?, ?, ?)";
                $stmt = $db->prepare($sql);
                $stmt->execute([
                    $kuafor['id'],
                    'sifre_degistirildi',
                    'Admin şifresi değiştirildi',
                    $_SERVER['REMOTE_ADDR'] ?? ''
                ]);
            } else {
                $error = 'Şifre değiştirme işlemi başarısız!';
            }
        } catch (Exception $e) {
            $error = 'Sistem hatası: ' . $e->getMessage();
        }
    }
}

// İstatistikleri al
$stats = [];

// Toplam randevu sayısı
$sql = "SELECT COUNT(*) as toplam FROM randevular WHERE kuafor_id = ?";
$stmt = $db->prepare($sql);
$stmt->execute([$kuafor['id']]);
$stats['toplam_randevu'] = $stmt->fetchColumn();

// Bu ayki randevular
$sql = "SELECT COUNT(*) as aylik FROM randevular WHERE kuafor_id = ? AND DATE(created_at) >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)";
$stmt = $db->prepare($sql);
$stmt->execute([$kuafor['id']]);
$stats['aylik_randevu'] = $stmt->fetchColumn();

// Bekleyen randevular
$sql = "SELECT COUNT(*) as bekleyen FROM randevular WHERE kuafor_id = ? AND durum = 'beklemede'";
$stmt = $db->prepare($sql);
$stmt->execute([$kuafor['id']]);
$stats['bekleyen_randevu'] = $stmt->fetchColumn();

// Toplam hizmet sayısı
$sql = "SELECT COUNT(*) as toplam FROM hizmetler WHERE kuafor_id = ? AND durum = 'aktif'";
$stmt = $db->prepare($sql);
$stmt->execute([$kuafor['id']]);
$stats['toplam_hizmet'] = $stmt->fetchColumn();

// Son randevular
$sql = "SELECT r.*, rh.hizmet_adi FROM randevular r 
        LEFT JOIN randevu_hizmetleri rh ON r.id = rh.randevu_id 
        WHERE r.kuafor_id = ? 
        ORDER BY r.created_at DESC LIMIT 5";
$stmt = $db->prepare($sql);
$stmt->execute([$kuafor['id']]);
$son_randevular = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($kuafor['isletme_adi']); ?> - Admin Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .sidebar-active {
            background: rgba(59, 130, 246, 0.1);
            border-right: 3px solid #3b82f6;
        }
        
        .stat-card {
            transition: all 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body class="bg-gray-100">
    <!-- Sidebar -->
    <div class="fixed inset-y-0 left-0 w-64 bg-white shadow-lg z-50">
        <!-- Logo -->
        <div class="flex items-center justify-center h-16 bg-blue-600">
            <div class="flex items-center">
                <i class="fas fa-store text-white text-2xl mr-3"></i>
                <span class="text-white text-xl font-bold">Admin Panel</span>
            </div>
        </div>
        
        <!-- Navigation -->
        <nav class="mt-8">
            <a href="dashboard.php?subdomain=<?php echo $subdomain; ?>" class="sidebar-active flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-tachometer-alt mr-3"></i>
                Dashboard
            </a>
            <a href="randevular.php?subdomain=<?php echo $subdomain; ?>" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-calendar-check mr-3"></i>
                Randevular
                <?php if ($stats['bekleyen_randevu'] > 0): ?>
                <span class="ml-auto bg-red-100 text-red-800 text-xs px-2 py-1 rounded-full"><?php echo $stats['bekleyen_randevu']; ?></span>
                <?php endif; ?>
            </a>
            <a href="hizmetler.php?subdomain=<?php echo $subdomain; ?>" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-cut mr-3"></i>
                Hizmetler
                <span class="ml-auto bg-blue-100 text-blue-800 text-xs px-2 py-1 rounded-full"><?php echo $stats['toplam_hizmet']; ?></span>
            </a>
            <a href="stilistler.php?subdomain=<?php echo $subdomain; ?>" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-users mr-3"></i>
                Stilistler
            </a>
            <a href="ayarlar.php?subdomain=<?php echo $subdomain; ?>" class="flex items-center px-6 py-3 text-gray-700 hover:bg-blue-50">
                <i class="fas fa-cog mr-3"></i>
                Ayarlar
            </a>
            <hr class="my-4 mx-6">
            <a href="../?subdomain=<?php echo $subdomain; ?>" target="_blank" class="flex items-center px-6 py-3 text-green-600 hover:bg-green-50">
                <i class="fas fa-external-link-alt mr-3"></i>
                Siteyi Görüntüle
            </a>
            <a href="logout.php?subdomain=<?php echo $subdomain; ?>" class="flex items-center px-6 py-3 text-red-600 hover:bg-red-50">
                <i class="fas fa-sign-out-alt mr-3"></i>
                Çıkış Yap
            </a>
        </nav>
    </div>
    
    <!-- Main Content -->
    <div class="ml-64 min-h-screen">
        <!-- Header -->
        <header class="bg-white shadow-sm border-b">
            <div class="flex items-center justify-between px-6 py-4">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Dashboard</h1>
                    <p class="text-gray-600"><?php echo htmlspecialchars($kuafor['isletme_adi']); ?> Yönetim Paneli</p>
                </div>
                <div class="flex items-center space-x-4">
                    <div class="text-right">
                        <p class="text-sm text-gray-600">Hoş geldin,</p>
                        <p class="font-semibold text-gray-800"><?php echo htmlspecialchars($_SESSION['kuafor_username']); ?></p>
                    </div>
                    <div class="w-10 h-10 bg-blue-600 rounded-full flex items-center justify-center">
                        <i class="fas fa-user text-white"></i>
                    </div>
                </div>
            </div>
        </header>
        
        <!-- Content -->
        <div class="p-6">
            <!-- Bildirimler -->
            <?php if ($success): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle mr-2"></i>
                        <?php echo htmlspecialchars($success); ?>
                    </div>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        <?php echo htmlspecialchars($error); ?>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                <!-- Toplam Randevu -->
                <div class="stat-card bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-calendar-check text-blue-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm text-gray-600">Toplam Randevu</p>
                            <p class="text-2xl font-bold text-gray-800"><?php echo $stats['toplam_randevu']; ?></p>
                        </div>
                    </div>
                    <div class="mt-4">
                        <span class="text-green-600 text-sm">
                            <i class="fas fa-arrow-up"></i> +<?php echo $stats['aylik_randevu']; ?> bu ay
                        </span>
                    </div>
                </div>
                
                <!-- Bekleyen Randevu -->
                <div class="stat-card bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-clock text-orange-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm text-gray-600">Bekleyen Randevu</p>
                            <p class="text-2xl font-bold text-gray-800"><?php echo $stats['bekleyen_randevu']; ?></p>
                        </div>
                    </div>
                    <div class="mt-4">
                        <?php if ($stats['bekleyen_randevu'] > 0): ?>
                            <span class="text-orange-600 text-sm">
                                <i class="fas fa-exclamation-triangle"></i> Onay bekliyor
                            </span>
                        <?php else: ?>
                            <span class="text-green-600 text-sm">
                                <i class="fas fa-check"></i> Hepsi onaylandı
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Toplam Hizmet -->
                <div class="stat-card bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-cut text-purple-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm text-gray-600">Aktif Hizmet</p>
                            <p class="text-2xl font-bold text-gray-800"><?php echo $stats['toplam_hizmet']; ?></p>
                        </div>
                    </div>
                    <div class="mt-4">
                        <span class="text-blue-600 text-sm">
                            <i class="fas fa-list"></i> Hizmet çeşidi
                        </span>
                    </div>
                </div>
                
                <!-- Site Ziyaretçi -->
                <div class="stat-card bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-eye text-green-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm text-gray-600">Site Ziyaretçi</p>
                            <p class="text-2xl font-bold text-gray-800">-</p>
                        </div>
                    </div>
                    <div class="mt-4">
                        <span class="text-gray-500 text-sm">
                            <i class="fas fa-info-circle"></i> Yakında aktif
                        </span>
                    </div>
                </div>
            </div>
            
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Son Randevular -->
                <div class="bg-white rounded-lg shadow">
                    <div class="p-6 border-b">
                        <h3 class="text-lg font-semibold text-gray-800">Son Randevular</h3>
                    </div>
                    <div class="p-6">
                        <?php if (empty($son_randevular)): ?>
                            <p class="text-gray-500 text-center py-8">Henüz randevu alınmamış</p>
                        <?php else: ?>
                            <div class="space-y-4">
                                <?php foreach ($son_randevular as $randevu): ?>
                                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                                        <div class="flex items-center">
                                            <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                                                <i class="fas fa-user text-blue-600"></i>
                                            </div>
                                            <div class="ml-3">
                                                <p class="font-medium text-gray-800"><?php echo htmlspecialchars($randevu['musteri_adi']); ?></p>
                                                <p class="text-sm text-gray-600"><?php echo date('d.m.Y H:i', strtotime($randevu['randevu_tarihi'] . ' ' . $randevu['randevu_saati'])); ?></p>
                                            </div>
                                        </div>
                                        <div class="text-right">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                <?php 
                                                    switch($randevu['durum']) {
                                                        case 'beklemede': echo 'bg-yellow-100 text-yellow-800'; break;
                                                        case 'onaylandi': echo 'bg-green-100 text-green-800'; break;
                                                        case 'tamamlandi': echo 'bg-blue-100 text-blue-800'; break;
                                                        case 'iptal': echo 'bg-red-100 text-red-800'; break;
                                                    }
                                                ?>">
                                                <?php echo ucfirst($randevu['durum']); ?>
                                            </span>
                                            <p class="text-xs text-gray-500 mt-1">
                                                ₺<?php echo number_format($randevu['toplam_fiyat'], 0); ?>
                                            </p>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="mt-4 text-center">
                                <a href="randevular.php?subdomain=<?php echo $subdomain; ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                    Tümünü Gör <i class="fas fa-arrow-right ml-1"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Şifre Değiştirme -->
                <div class="bg-white rounded-lg shadow">
                    <div class="p-6 border-b">
                        <div class="flex items-center">
                            <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="fas fa-key text-red-600"></i>
                            </div>
                            <div>
                                <h3 class="text-lg font-semibold text-gray-800">Şifre Değiştir</h3>
                                <p class="text-sm text-gray-600">Admin şifrenizi güvenli bir şekilde değiştirin</p>
                            </div>
                        </div>
                    </div>
                    <div class="p-6">
                        <form method="POST" class="space-y-4">
                            <div>
                                <label for="current_password" class="block text-sm font-medium text-gray-700 mb-2">
                                    Mevcut Şifre
                                </label>
                                <input type="password" 
                                       id="current_password" 
                                       name="current_password" 
                                       required 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                       placeholder="Mevcut şifrenizi girin">
                            </div>
                            
                            <div>
                                <label for="new_password" class="block text-sm font-medium text-gray-700 mb-2">
                                    Yeni Şifre
                                </label>
                                <input type="password" 
                                       id="new_password" 
                                       name="new_password" 
                                       required 
                                       minlength="6"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                       placeholder="En az 6 karakter">
                            </div>
                            
                            <div>
                                <label for="confirm_password" class="block text-sm font-medium text-gray-700 mb-2">
                                    Yeni Şifre (Tekrar)
                                </label>
                                <input type="password" 
                                       id="confirm_password" 
                                       name="confirm_password" 
                                       required 
                                       minlength="6"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                       placeholder="Yeni şifrenizi tekrar girin">
                            </div>
                            
                            <button type="submit" 
                                    name="change_password"
                                    class="w-full bg-red-600 text-white py-2 px-4 rounded-lg hover:bg-red-700 transition duration-300">
                                <i class="fas fa-key mr-2"></i>Şifre Değiştir
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            
            <!-- Hızlı İşlemler -->
            <div class="mt-8 bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Hızlı İşlemler</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <a href="randevular.php?subdomain=<?php echo $subdomain; ?>" class="flex items-center p-4 bg-blue-50 rounded-lg hover:bg-blue-100 transition duration-200">
                        <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center">
                            <i class="fas fa-calendar-plus text-white"></i>
                        </div>
                        <div class="ml-4">
                            <p class="font-medium text-gray-800">Randevu Yönetimi</p>
                            <p class="text-sm text-gray-600">Randevuları görüntüle ve yönet</p>
                        </div>
                    </a>
                    
                    <a href="hizmetler.php?subdomain=<?php echo $subdomain; ?>" class="flex items-center p-4 bg-green-50 rounded-lg hover:bg-green-100 transition duration-200">
                        <div class="w-12 h-12 bg-green-600 rounded-lg flex items-center justify-center">
                            <i class="fas fa-cut text-white"></i>
                        </div>
                        <div class="ml-4">
                            <p class="font-medium text-gray-800">Hizmet Yönetimi</p>
                            <p class="text-sm text-gray-600">Hizmetleri düzenle ve fiyatları güncelle</p>
                        </div>
                    </a>
                    
                    <a href="../?subdomain=<?php echo $subdomain; ?>" target="_blank" class="flex items-center p-4 bg-purple-50 rounded-lg hover:bg-purple-100 transition duration-200">
                        <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center">
                            <i class="fas fa-external-link-alt text-white"></i>
                        </div>
                        <div class="ml-4">
                            <p class="font-medium text-gray-800">Siteyi Görüntüle</p>
                            <p class="text-sm text-gray-600">Müşteri gözüyle sitenizi inceleyin</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Şifre eşleşme kontrolü
        document.getElementById('confirm_password').addEventListener('input', function() {
            const newPassword = document.getElementById('new_password').value;
            const confirmPassword = this.value;
            
            if (newPassword !== confirmPassword) {
                this.setCustomValidity('Şifreler eşleşmiyor');
            } else {
                this.setCustomValidity('');
            }
        });
        
        // Form gönderme onayı
        document.querySelector('form').addEventListener('submit', function(e) {
            if (e.submitter.name === 'change_password') {
                if (!confirm('Şifrenizi değiştirmek istediğinizden emin misiniz?')) {
                    e.preventDefault();
                }
            }
        });
        
        // Sayfa yüklendiğinde animasyonlar
        document.addEventListener('DOMContentLoaded', function() {
            const statCards = document.querySelectorAll('.stat-card');
            statCards.forEach((card, index) => {
                setTimeout(() => {
                    card.style.opacity = '0';
                    card.style.transform = 'translateY(20px)';
                    card.style.transition = 'all 0.5s ease';
                    
                    setTimeout(() => {
                        card.style.opacity = '1';
                        card.style.transform = 'translateY(0)';
                    }, 100);
                }, index * 100);
            });
        });
    </script>
</body>
</html>
