<?php
session_start();
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/classes/Kuafor.php';

// Ana site ayarlarını al
$db = Database::getInstance();
$sql = "SELECT ayar_adi, ayar_degeri FROM ana_site_ayarlari";
$stmt = $db->query($sql);
$ayarlar = [];
if ($stmt) {
    while ($row = $stmt->fetch()) {
        $ayarlar[$row['ayar_adi']] = $row['ayar_degeri'];
    }
}

// Varsayılan değerler
$site_baslik = $ayarlar['site_baslik'] ?? 'Kuaförünüz İçin Profesyonel Dijital Çözüm';
$site_alt_baslik = $ayarlar['site_alt_baslik'] ?? 'Modern randevu sistemi + Şık web sitesi = Daha fazla müşteri';
$ana_renk = $ayarlar['ana_renk'] ?? 'mavi-turuncu';

// İstatistikler
$kuafor = new Kuafor();
$stats = $kuafor->getDashboardStats();

// Portföy örnekleri (son 6 kuaför)
$portfolio = $kuafor->getList(['limit' => 6, 'durum' => 'aktif']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($site_baslik); ?></title>
    <meta name="description" content="Kuaför ve berber salonları için profesyonel web sitesi ve randevu sistemi. Modern tasarım, kolay yönetim, online randevu alma sistemi.">
    <meta name="keywords" content="kuaför web sitesi, berber randevu sistemi, online randevu, kuaför dijital çözümleri, web tasarım">
    
    <!-- Open Graph -->
    <meta property="og:title" content="<?php echo htmlspecialchars($site_baslik); ?>">
    <meta property="og:description" content="Kuaför ve berber salonları için profesyonel dijital çözümler">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://emrebaytas.com.tr/kuafor-sistem">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Alpine.js -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .hero-pattern {
            background-image: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.1'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
        }
        
        .typewriter {
            overflow: hidden;
            border-right: .15em solid #667eea;
            white-space: nowrap;
            margin: 0 auto;
            letter-spacing: .15em;
            animation: typing 3.5s steps(40, end), blink-caret .75s step-end infinite;
        }
        
        @keyframes typing {
            from { width: 0 }
            to { width: 100% }
        }
        
        @keyframes blink-caret {
            from, to { border-color: transparent }
            50% { border-color: #667eea; }
        }
        
        .floating {
            animation: floating 3s ease-in-out infinite;
        }
        
        @keyframes floating {
            0% { transform: translate(0, 0px); }
            50% { transform: translate(0, -10px); }
            100% { transform: translate(0, -0px); }
        }
        
        .card-hover {
            transition: all 0.3s ease;
        }
        
        .card-hover:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <nav class="bg-white shadow-lg fixed w-full z-50" x-data="{ open: false }">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <h1 class="text-2xl font-bold text-gray-800">KuaförSistem</h1>
                    </div>
                </div>
                
                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="#anasayfa" class="text-gray-700 hover:text-blue-600 transition duration-300">Ana Sayfa</a>
                    <a href="#hizmetler" class="text-gray-700 hover:text-blue-600 transition duration-300">Hizmetler</a>
                    <a href="#portfoy" class="text-gray-700 hover:text-blue-600 transition duration-300">Portföy</a>
                    <a href="#iletisim" class="text-gray-700 hover:text-blue-600 transition duration-300">İletişim</a>
                    <a href="xpanel" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                        <i class="fas fa-user-shield mr-2"></i>Admin Girişi
                    </a>
                </div>
                
                <!-- Mobile menu button -->
                <div class="md:hidden flex items-center">
                    <button @click="open = !open" class="text-gray-700 hover:text-blue-600">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Mobile Menu -->
        <div x-show="open" x-transition class="md:hidden bg-white border-t">
            <div class="px-2 pt-2 pb-3 space-y-1">
                <a href="#anasayfa" class="block px-3 py-2 text-gray-700 hover:text-blue-600">Ana Sayfa</a>
                <a href="#hizmetler" class="block px-3 py-2 text-gray-700 hover:text-blue-600">Hizmetler</a>
                <a href="#portfoy" class="block px-3 py-2 text-gray-700 hover:text-blue-600">Portföy</a>
                <a href="#iletisim" class="block px-3 py-2 text-gray-700 hover:text-blue-600">İletişim</a>
                <a href="xpanel" class="block px-3 py-2 text-blue-600 font-semibold">Admin Girişi</a>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section id="anasayfa" class="gradient-bg hero-pattern min-h-screen flex items-center pt-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Sol Taraf - Metin -->
                <div class="text-white">
                    <h1 class="text-5xl lg:text-6xl font-bold mb-6 typewriter">
                        <?php echo htmlspecialchars($site_baslik); ?>
                    </h1>
                    <p class="text-xl lg:text-2xl mb-8 opacity-90">
                        <?php echo htmlspecialchars($site_alt_baslik); ?>
                    </p>
                    
                    <!-- İstatistikler -->
                    <div class="grid grid-cols-2 gap-4 mb-8">
                        <div class="bg-white bg-opacity-20 rounded-lg p-4 text-center">
                            <div class="text-3xl font-bold"><?php echo $stats['toplam_kuafor']; ?>+</div>
                            <div class="text-sm opacity-80">Mutlu Kuaför</div>
                        </div>
                        <div class="bg-white bg-opacity-20 rounded-lg p-4 text-center">
                            <div class="text-3xl font-bold"><?php echo $stats['toplam_randevu']; ?>+</div>
                            <div class="text-sm opacity-80">Başarılı Randevu</div>
                        </div>
                    </div>
                    
                    <!-- Butonlar -->
                    <div class="flex flex-col sm:flex-row gap-4">
                        <a href="#iletisim" class="bg-white text-blue-600 px-8 py-4 rounded-lg font-semibold hover:bg-gray-100 transition duration-300 text-center">
                            <i class="fas fa-rocket mr-2"></i>Hemen Başla
                        </a>
                        <a href="#portfoy" class="border-2 border-white text-white px-8 py-4 rounded-lg font-semibold hover:bg-white hover:text-blue-600 transition duration-300 text-center">
                            <i class="fas fa-eye mr-2"></i>Örnekleri Gör
                        </a>
                    </div>
                </div>
                
                <!-- Sağ Taraf - Mockup -->
                <div class="floating">
                    <div class="relative">
                        <div class="bg-white rounded-2xl shadow-2xl p-8 transform rotate-3">
                            <div class="bg-gradient-to-r from-blue-500 to-purple-600 rounded-lg p-6 text-white">
                                <h3 class="text-xl font-bold mb-4">Demo Kuaför</h3>
                                <div class="space-y-3">
                                    <div class="flex items-center justify-between">
                                        <span>Bugünkü Randevular</span>
                                        <span class="bg-white text-blue-600 px-2 py-1 rounded text-sm font-bold">12</span>
                                    </div>
                                    <div class="flex items-center justify-between">
                                        <span>Günlük Gelir</span>
                                        <span class="bg-white text-blue-600 px-2 py-1 rounded text-sm font-bold">₺1,250</span>
                                    </div>
                                    <div class="flex items-center justify-between">
                                        <span>Müşteri Sayısı</span>
                                        <span class="bg-white text-blue-600 px-2 py-1 rounded text-sm font-bold">847</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Hizmetler Section -->
    <section id="hizmetler" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-800 mb-4">Hizmetlerimiz</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    Kuaför işletmeniz için ihtiyacınız olan tüm dijital çözümler tek bir yerde
                </p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Web Sitesi Tasarımı -->
                <div class="card-hover bg-white rounded-xl shadow-lg p-8 border border-gray-100">
                    <div class="w-16 h-16 bg-blue-100 rounded-lg flex items-center justify-center mb-6">
                        <i class="fas fa-palette text-2xl text-blue-600"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-800 mb-4">Web Site Tasarımı</h3>
                    <ul class="text-gray-600 space-y-2 mb-6">
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Profesyonel tasarım</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Mobil uyumlu</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>SEO optimizasyonu</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>50+ tema seçeneği</li>
                    </ul>
                </div>
                
                <!-- Randevu Sistemi -->
                <div class="card-hover bg-white rounded-xl shadow-lg p-8 border border-gray-100">
                    <div class="w-16 h-16 bg-green-100 rounded-lg flex items-center justify-center mb-6">
                        <i class="fas fa-calendar-alt text-2xl text-green-600"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-800 mb-4">Randevu Sistemi</h3>
                    <ul class="text-gray-600 space-y-2 mb-6">
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Online randevu alma</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Otomatik yönetim</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Stilist yönetimi</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Müsaitlik kontrolü</li>
                    </ul>
                </div>
                
                <!-- Teknik Destek -->
                <div class="card-hover bg-white rounded-xl shadow-lg p-8 border border-gray-100">
                    <div class="w-16 h-16 bg-purple-100 rounded-lg flex items-center justify-center mb-6">
                        <i class="fas fa-headset text-2xl text-purple-600"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-800 mb-4">Teknik Destek</h3>
                    <ul class="text-gray-600 space-y-2 mb-6">
                        <li><i class="fas fa-check text-green-500 mr-2"></i>İlk 3 ay ücretsiz bakım</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Özel destek kanalı</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Hızlı çözüm</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Uzaktan yardım</li>
                    </ul>
                </div>
                
                <!-- Analitik Raporlar -->
                <div class="card-hover bg-white rounded-xl shadow-lg p-8 border border-gray-100">
                    <div class="w-16 h-16 bg-orange-100 rounded-lg flex items-center justify-center mb-6">
                        <i class="fas fa-chart-bar text-2xl text-orange-600"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-800 mb-4">Analitik Raporlar</h3>
                    <ul class="text-gray-600 space-y-2 mb-6">
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Müşteri analizi</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Gelir raporları</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Performans takibi</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Trend analizi</li>
                    </ul>
                </div>
                
                <!-- Kolay Yönetim -->
                <div class="card-hover bg-white rounded-xl shadow-lg p-8 border border-gray-100">
                    <div class="w-16 h-16 bg-red-100 rounded-lg flex items-center justify-center mb-6">
                        <i class="fas fa-cogs text-2xl text-red-600"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-800 mb-4">Kolay Yönetim</h3>
                    <ul class="text-gray-600 space-y-2 mb-6">
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Sürükle bırak</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Tek tıkla güncelleme</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Kullanıcı dostu</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Eğitim gerektirmez</li>
                    </ul>
                </div>
                
                <!-- Özelleştirme -->
                <div class="card-hover bg-white rounded-xl shadow-lg p-8 border border-gray-100">
                    <div class="w-16 h-16 bg-indigo-100 rounded-lg flex items-center justify-center mb-6">
                        <i class="fas fa-paint-brush text-2xl text-indigo-600"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-800 mb-4">Özelleştirme</h3>
                    <ul class="text-gray-600 space-y-2 mb-6">
                        <li><i class="fas fa-check text-green-500 mr-2"></i>50+ renk teması</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Kendi içeriğiniz</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Sınırsız değişim</li>
                        <li><i class="fas fa-check text-green-500 mr-2"></i>Marka uyumu</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Portföy Section -->
    <section id="portfoy" class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-800 mb-4">Başarı Hikayeleri</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    Sistemimizi kullanan kuaför ve berber salonlarından örnekler
                </p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php foreach ($portfolio as $kuafor_item): ?>
                <div class="card-hover bg-white rounded-xl shadow-lg overflow-hidden">
                    <div class="h-48 bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center">
                        <div class="text-white text-center">
                            <h3 class="text-2xl font-bold"><?php echo htmlspecialchars($kuafor_item['isletme_adi']); ?></h3>
                            <p class="text-blue-100"><?php echo htmlspecialchars($kuafor_item['sehir']); ?></p>
                        </div>
                    </div>
                    <div class="p-6">
                        <p class="text-gray-600 mb-4">
                            <?php echo htmlspecialchars($kuafor_item['alt_yazi'] ?: 'Profesyonel kuaför hizmetleri'); ?>
                        </p>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-500">
                                <i class="fas fa-calendar mr-1"></i>
                                <?php echo date('M Y', strtotime($kuafor_item['created_at'])); ?>
                            </span>
                            <a href="https://<?php echo $kuafor_item['subdomain']; ?>.emrebaytas.com.tr" 
                               target="_blank" 
                               class="text-blue-600 hover:text-blue-800 font-semibold">
                                <i class="fas fa-external-link-alt mr-1"></i>Siteyi Gör
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- İletişim Section -->
    <section id="iletisim" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-800 mb-4">Bize Ulaşın</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    Kuaför işletmeniz için dijital çözümler hakkında bilgi almak için formu doldurun
                </p>
            </div>
            
            <div class="max-w-4xl mx-auto">
                <form action="api/contact.php" method="POST" class="bg-gray-50 rounded-2xl p-8">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div>
                            <label for="ad_soyad" class="block text-sm font-medium text-gray-700 mb-2">Ad Soyad *</label>
                            <input type="text" id="ad_soyad" name="ad_soyad" required 
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700 mb-2">E-posta *</label>
                            <input type="email" id="email" name="email" required 
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <div>
                            <label for="telefon" class="block text-sm font-medium text-gray-700 mb-2">Telefon</label>
                            <input type="tel" id="telefon" name="telefon" 
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <div>
                            <label for="isletme_adi" class="block text-sm font-medium text-gray-700 mb-2">İşletme Adı</label>
                            <input type="text" id="isletme_adi" name="isletme_adi" 
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <div>
                            <label for="sehir" class="block text-sm font-medium text-gray-700 mb-2">Şehir</label>
                            <input type="text" id="sehir" name="sehir" 
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Hizmet Türü *</label>
                            <div class="space-y-2">
                                <label class="flex items-center">
                                    <input type="checkbox" name="hizmet_turu[]" value="web_sitesi" class="mr-2">
                                    <span>Web Sitesi</span>
                                </label>
                                <label class="flex items-center">
                                    <input type="checkbox" name="hizmet_turu[]" value="randevu_sistemi" class="mr-2">
                                    <span>Randevu Sistemi</span>
                                </label>
                                <label class="flex items-center">
                                    <input type="checkbox" name="hizmet_turu[]" value="her_ikisi" class="mr-2">
                                    <span>Her İkisi</span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-6">
                        <label for="mesaj" class="block text-sm font-medium text-gray-700 mb-2">Mesajınız *</label>
                        <textarea id="mesaj" name="mesaj" rows="4" required 
                                  class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                  placeholder="Projeniz hakkında detayları yazın..."></textarea>
                    </div>
                    
                    <div class="text-center">
                        <button type="submit" 
                                class="bg-blue-600 text-white px-8 py-4 rounded-lg font-semibold hover:bg-blue-700 transition duration-300">
                            <i class="fas fa-paper-plane mr-2"></i>Mesaj Gönder
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div>
                    <h3 class="text-xl font-bold mb-4">KuaförSistem</h3>
                    <p class="text-gray-300 mb-4">
                        Kuaför ve berber salonları için profesyonel dijital çözümler sunuyoruz.
                    </p>
                    <div class="flex space-x-4">
                        <a href="#" class="text-gray-300 hover:text-white transition duration-300">
                            <i class="fab fa-facebook-f text-xl"></i>
                        </a>
                        <a href="#" class="text-gray-300 hover:text-white transition duration-300">
                            <i class="fab fa-instagram text-xl"></i>
                        </a>
                        <a href="#" class="text-gray-300 hover:text-white transition duration-300">
                            <i class="fab fa-linkedin-in text-xl"></i>
                        </a>
                    </div>
                </div>
                
                <div>
                    <h4 class="text-lg font-semibold mb-4">Hızlı Linkler</h4>
                    <ul class="space-y-2">
                        <li><a href="#anasayfa" class="text-gray-300 hover:text-white transition duration-300">Ana Sayfa</a></li>
                        <li><a href="#hizmetler" class="text-gray-300 hover:text-white transition duration-300">Hizmetler</a></li>
                        <li><a href="#portfoy" class="text-gray-300 hover:text-white transition duration-300">Portföy</a></li>
                        <li><a href="#iletisim" class="text-gray-300 hover:text-white transition duration-300">İletişim</a></li>
                    </ul>
                </div>
                
                <div>
                    <h4 class="text-lg font-semibold mb-4">İletişim</h4>
                    <div class="space-y-2 text-gray-300">
                        <p><i class="fas fa-envelope mr-2"></i>info@emrebaytas.com.tr</p>
                        <p><i class="fas fa-globe mr-2"></i>emrebaytas.com.tr</p>
                    </div>
                </div>
            </div>
            
            <div class="border-t border-gray-700 mt-8 pt-8 text-center text-gray-300">
                <p>&copy; 2025 KuaförSistem. Tüm hakları saklıdır.</p>
                <p class="mt-2">
                    <a href="https://emrebaytas.com.tr" target="_blank" class="text-blue-400 hover:text-blue-300">
                        Emre Baytaş
                    </a> tarafından geliştirilmiştir.
                </p>
            </div>
        </div>
    </footer>

    <!-- Smooth Scroll -->
    <script>
        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
        
        // Form submission
        document.querySelector('form').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            fetch('api/contact.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Mesajınız başarıyla gönderildi! En kısa sürede size dönüş yapacağız.');
                    this.reset();
                } else {
                    alert('Hata: ' + data.error);
                }
            })
            .catch(error => {
                alert('Bir hata oluştu. Lütfen tekrar deneyin.');
            });
        });
    </script>
</body>
</html>
