<?php
/**
 * Kuaför Sistemi - Basit ve Kesin Çalışan Kurulum
 * Bu sefer kesinlikle çalışacak!
 */

require_once __DIR__ . '/../config/database.php';

// Hata raporlamayı aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html>
<html lang='tr'>
<head>
    <meta charset='UTF-8'>
    <title>Kuaför Sistemi - Basit Kurulum</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; background: #f8f9fa; }
        .container { background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .success { color: #155724; background: #d4edda; padding: 10px; border: 1px solid #c3e6cb; margin: 5px 0; border-radius: 5px; }
        .error { color: #721c24; background: #f8d7da; padding: 10px; border: 1px solid #f5c6cb; margin: 5px 0; border-radius: 5px; }
        .info { color: #0c5460; background: #d1ecf1; padding: 10px; border: 1px solid #bee5eb; margin: 5px 0; border-radius: 5px; }
        h1 { color: #343a40; text-align: center; margin-bottom: 30px; }
    </style>
</head>
<body>
    <div class='container'>
        <h1>🚀 Kuaför Sistemi - Basit Kurulum</h1>";

try {
    // Veritabanı bağlantısı
    $db = Database::getInstance();
    $pdo = $db->getConnection();
    
    // Charset ayarla
    $pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci");
    
    echo "<div class='info'>✅ Veritabanı bağlantısı başarılı!</div>";
    echo "<div class='info'>✅ UTF8MB4 charset ayarlandı</div>";
    
    // 1. Ana site ayarları tablosu
    echo "<div class='info'>📋 Ana site ayarları tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS ana_site_ayarlari (
        id INT AUTO_INCREMENT PRIMARY KEY,
        ayar_adi VARCHAR(100) UNIQUE NOT NULL,
        ayar_degeri TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ ana_site_ayarlari tablosu oluşturuldu</div>";
    
    // 2. Kuaförler tablosu
    echo "<div class='info'>📋 Kuaförler tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS kuaforler (
        id INT AUTO_INCREMENT PRIMARY KEY,
        isletme_adi VARCHAR(100) NOT NULL,
        subdomain VARCHAR(50) UNIQUE NOT NULL,
        sahip_adi VARCHAR(100) NOT NULL,
        telefon VARCHAR(20),
        email VARCHAR(100),
        adres TEXT,
        sehir VARCHAR(50),
        ilce VARCHAR(50),
        admin_username VARCHAR(50) NOT NULL,
        admin_password VARCHAR(255) NOT NULL,
        durum ENUM('aktif', 'pasif', 'beklemede') DEFAULT 'aktif',
        tema_renk VARCHAR(20) DEFAULT 'mavi',
        banner_resmi VARCHAR(255),
        karsilama_yazisi VARCHAR(255),
        alt_yazi TEXT,
        seo_keywords TEXT,
        sosyal_medya TEXT,
        calisma_saatleri TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ kuaforler tablosu oluşturuldu</div>";
    
    // 3. Stilistler tablosu
    echo "<div class='info'>📋 Stilistler tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS stilistler (
        id INT AUTO_INCREMENT PRIMARY KEY,
        kuafor_id INT NOT NULL,
        isim_soyisim VARCHAR(100) NOT NULL,
        uzmanlik_alani VARCHAR(100),
        profil_resmi VARCHAR(255),
        username VARCHAR(50) NOT NULL,
        password VARCHAR(255) NOT NULL,
        durum ENUM('aktif', 'pasif') DEFAULT 'aktif',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ stilistler tablosu oluşturuldu</div>";
    
    // 4. Hizmetler tablosu
    echo "<div class='info'>📋 Hizmetler tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS hizmetler (
        id INT AUTO_INCREMENT PRIMARY KEY,
        kuafor_id INT NOT NULL,
        hizmet_adi VARCHAR(100) NOT NULL,
        aciklama TEXT,
        resim VARCHAR(255),
        sure_dakika INT NOT NULL,
        fiyat DECIMAL(10,2) NOT NULL,
        anasayfa_goster BOOLEAN DEFAULT TRUE,
        sira_no INT DEFAULT 0,
        durum ENUM('aktif', 'pasif') DEFAULT 'aktif',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ hizmetler tablosu oluşturuldu</div>";
    
    // 5. Randevular tablosu
    echo "<div class='info'>📋 Randevular tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS randevular (
        id INT AUTO_INCREMENT PRIMARY KEY,
        kuafor_id INT NOT NULL,
        stilist_id INT NOT NULL,
        musteri_adi VARCHAR(100) NOT NULL,
        musteri_telefon VARCHAR(20) NOT NULL,
        randevu_tarihi DATE NOT NULL,
        randevu_saati TIME NOT NULL,
        bitis_saati TIME NOT NULL,
        toplam_sure INT NOT NULL,
        toplam_fiyat DECIMAL(10,2) NOT NULL,
        durum ENUM('beklemede', 'onaylandi', 'tamamlandi', 'iptal') DEFAULT 'beklemede',
        notlar TEXT,
        okundu BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE,
        FOREIGN KEY (stilist_id) REFERENCES stilistler(id) ON DELETE CASCADE
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ randevular tablosu oluşturuldu</div>";
    
    // 6. Randevu hizmetleri tablosu
    echo "<div class='info'>📋 Randevu hizmetleri tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS randevu_hizmetleri (
        id INT AUTO_INCREMENT PRIMARY KEY,
        randevu_id INT NOT NULL,
        hizmet_id INT NOT NULL,
        hizmet_adi VARCHAR(100) NOT NULL,
        sure_dakika INT NOT NULL,
        fiyat DECIMAL(10,2) NOT NULL,
        FOREIGN KEY (randevu_id) REFERENCES randevular(id) ON DELETE CASCADE,
        FOREIGN KEY (hizmet_id) REFERENCES hizmetler(id) ON DELETE CASCADE
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ randevu_hizmetleri tablosu oluşturuldu</div>";
    
    // 7. İletişim formları tablosu
    echo "<div class='info'>📋 İletişim formları tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS iletisim_formlari (
        id INT AUTO_INCREMENT PRIMARY KEY,
        ad_soyad VARCHAR(100) NOT NULL,
        email VARCHAR(100) NOT NULL,
        telefon VARCHAR(20),
        isletme_adi VARCHAR(100),
        sehir VARCHAR(50),
        mesaj TEXT NOT NULL,
        hizmet_turu SET('web_sitesi', 'randevu_sistemi', 'her_ikisi') NOT NULL,
        durum ENUM('yeni', 'okundu', 'cevaplandi') DEFAULT 'yeni',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ iletisim_formlari tablosu oluşturuldu</div>";
    
    // 8. Sistem logları tablosu
    echo "<div class='info'>📋 Sistem logları tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS sistem_loglari (
        id INT AUTO_INCREMENT PRIMARY KEY,
        kuafor_id INT NULL,
        islem_tipi VARCHAR(50) NOT NULL,
        aciklama TEXT NOT NULL,
        ip_adresi VARCHAR(45),
        user_agent TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE SET NULL
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ sistem_loglari tablosu oluşturuldu</div>";
    
    // 9. Destek talepleri tablosu
    echo "<div class='info'>📋 Destek talepleri tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS destek_talepleri (
        id INT AUTO_INCREMENT PRIMARY KEY,
        kuafor_id INT NOT NULL,
        konu VARCHAR(255) NOT NULL,
        kategori ENUM('teknik', 'odeme', 'genel', 'acil') DEFAULT 'genel',
        oncelik ENUM('dusuk', 'orta', 'yuksek') DEFAULT 'orta',
        durum ENUM('acik', 'cevaplandi', 'cozuldu', 'kapali') DEFAULT 'acik',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ destek_talepleri tablosu oluşturuldu</div>";
    
    // 10. Destek mesajları tablosu
    echo "<div class='info'>📋 Destek mesajları tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS destek_mesajlari (
        id INT AUTO_INCREMENT PRIMARY KEY,
        talep_id INT NOT NULL,
        gonderen_tip ENUM('kuafor', 'admin') NOT NULL,
        gonderen_id INT NOT NULL,
        mesaj TEXT NOT NULL,
        dosya_eki VARCHAR(255),
        okundu BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (talep_id) REFERENCES destek_talepleri(id) ON DELETE CASCADE
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ destek_mesajlari tablosu oluşturuldu</div>";
    
    // 11. Site ayarları tablosu
    echo "<div class='info'>📋 Site ayarları tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS site_ayarlari (
        id INT AUTO_INCREMENT PRIMARY KEY,
        kuafor_id INT NOT NULL,
        ayar_adi VARCHAR(100) NOT NULL,
        ayar_degeri TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ site_ayarlari tablosu oluşturuldu</div>";
    
    // 12. Müsaitlik yönetimi tablosu
    echo "<div class='info'>📋 Müsaitlik yönetimi tablosu oluşturuluyor...</div>";
    $sql = "CREATE TABLE IF NOT EXISTS musaitlik_yonetimi (
        id INT AUTO_INCREMENT PRIMARY KEY,
        kuafor_id INT NOT NULL,
        stilist_id INT NULL,
        baslangic_tarihi DATE NOT NULL,
        bitis_tarihi DATE NOT NULL,
        baslangic_saati TIME NULL,
        bitis_saati TIME NULL,
        sebep VARCHAR(255),
        durum ENUM('aktif', 'pasif') DEFAULT 'aktif',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE,
        FOREIGN KEY (stilist_id) REFERENCES stilistler(id) ON DELETE CASCADE
    )";
    $pdo->exec($sql);
    echo "<div class='success'>✅ musaitlik_yonetimi tablosu oluşturuldu</div>";
    
    // ŞIMDI VERİLERİ EKLE
    echo "<div class='info'>📝 Varsayılan veriler ekleniyor...</div>";
    
    // Ana site ayarları var mı kontrol et
    $count = $pdo->query("SELECT COUNT(*) FROM ana_site_ayarlari")->fetchColumn();
    
    if ($count == 0) {
        $stmt = $pdo->prepare("INSERT INTO ana_site_ayarlari (ayar_adi, ayar_degeri) VALUES (?, ?)");
        
        $ayarlar = [
            ['site_baslik', 'Kuaförünüz İçin Profesyonel Dijital Çözüm'],
            ['site_alt_baslik', 'Modern randevu sistemi + Şık web sitesi = Daha fazla müşteri'],
            ['hero_video', ''],
            ['ana_renk', 'mavi-turuncu'],
            ['hizmetler_aktif', '1'],
            ['portfoy_aktif', '1'],
            ['iletisim_aktif', '1']
        ];
        
        foreach ($ayarlar as $ayar) {
            $stmt->execute($ayar);
        }
        
        echo "<div class='success'>✅ Varsayılan veriler eklendi</div>";
    } else {
        echo "<div class='info'>ℹ️ Varsayılan veriler zaten mevcut</div>";
    }
    
    // Demo kuaför oluştur
    echo "<div class='info'>👤 Demo kuaför kontrol ediliyor...</div>";
    $demo = $pdo->query("SELECT id FROM kuaforler WHERE subdomain = 'demo'")->fetch();
    
    if (!$demo) {
        echo "<div class='info'>👤 Demo kuaför oluşturuluyor...</div>";
        
        $stmt = $pdo->prepare("INSERT INTO kuaforler (
            isletme_adi, subdomain, sahip_adi, telefon, email, adres, sehir, ilce,
            admin_username, admin_password, karsilama_yazisi, alt_yazi, seo_keywords,
            sosyal_medya, calisma_saatleri
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        
        $stmt->execute([
            'Demo Kuaför',
            'demo',
            'Demo Kullanıcı',
            '0555 123 45 67',
            'demo@kuafor.com',
            'Demo Mahallesi, Demo Sokak No:1',
            'İstanbul',
            'Kadıköy',
            'admin',
            password_hash('123456', PASSWORD_DEFAULT),
            'Demo Kuaföre Hoş Geldiniz',
            'Profesyonel kuaför hizmetleri',
            'istanbul kuaför, kadıköy berber, saç kesimi',
            '{"instagram":"https://instagram.com/demokuafor","facebook":"https://facebook.com/demokuafor"}',
            '{"pazartesi":{"aktif":true,"acilis":"09:00","kapanis":"18:00"},"sali":{"aktif":true,"acilis":"09:00","kapanis":"18:00"},"carsamba":{"aktif":true,"acilis":"09:00","kapanis":"18:00"},"persembe":{"aktif":true,"acilis":"09:00","kapanis":"18:00"},"cuma":{"aktif":true,"acilis":"09:00","kapanis":"18:00"},"cumartesi":{"aktif":true,"acilis":"09:00","kapanis":"17:00"},"pazar":{"aktif":false,"acilis":"","kapanis":""}}'
        ]);
        
        $kuafor_id = $pdo->lastInsertId();
        echo "<div class='success'>✅ Demo kuaför oluşturuldu (ID: $kuafor_id)</div>";
        
        // Demo stilist
        $stmt = $pdo->prepare("INSERT INTO stilistler (kuafor_id, isim_soyisim, uzmanlik_alani, username, password) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$kuafor_id, 'Demo Stilist', 'Saç & Sakal', 'demo', password_hash('123456', PASSWORD_DEFAULT)]);
        echo "<div class='success'>✅ Demo stilist oluşturuldu</div>";
        
        // Demo hizmetler
        $services = [
            ['Saç Kesimi', 'Profesyonel saç kesimi', 30, 100.00, 1],
            ['Sakal Tıraşı', 'Geleneksel sakal tıraşı', 15, 50.00, 2],
            ['Saç Yıkama', 'Şampuan ve bakım', 10, 30.00, 3],
            ['Fön Çekimi', 'Profesyonel fön', 20, 80.00, 4]
        ];
        
        $stmt = $pdo->prepare("INSERT INTO hizmetler (kuafor_id, hizmet_adi, aciklama, sure_dakika, fiyat, sira_no) VALUES (?, ?, ?, ?, ?, ?)");
        
        foreach ($services as $service) {
            $stmt->execute([$kuafor_id, $service[0], $service[1], $service[2], $service[3], $service[4]]);
        }
        
        echo "<div class='success'>✅ Demo hizmetler oluşturuldu (4 adet)</div>";
        
    } else {
        echo "<div class='info'>ℹ️ Demo kuaför zaten mevcut (ID: " . $demo['id'] . ")</div>";
    }
    
    // Tabloları listele
    echo "<h2>📊 Oluşturulan Tablolar</h2>";
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    
    foreach ($tables as $table) {
        $count = $pdo->query("SELECT COUNT(*) FROM `$table`")->fetchColumn();
        echo "<div class='info'>📋 $table: $count kayıt</div>";
    }
    
    echo "<h2>🎉 KURULUM BAŞARIYLA TAMAMLANDI!</h2>";
    echo "<div class='success'>
        <h3>🔗 Test Linkleri:</h3>
        <p><strong>Ana Site:</strong> <a href='../index.php' target='_blank'>index.php</a></p>
        <p><strong>Demo Sayfası:</strong> <a href='../demo.html' target='_blank'>demo.html</a></p>
        <p><strong>Super Admin:</strong> <a href='../xpanel' target='_blank'>xpanel</a></p>
        <p><strong>Demo Kuaför Admin:</strong> demo.emrebaytas.com.tr/admin (admin/123456)</p>
    </div>";
    
} catch (Exception $e) {
    echo "<div class='error'>❌ HATA: " . $e->getMessage() . "</div>";
    echo "<div class='error'>Stack Trace: " . $e->getTraceAsString() . "</div>";
}

echo "</div></body></html>";
?>
