-- Kuaför Sistemi Veritabanı Şeması
-- Hosting: Rabisu (emrebaytas.com.tr)
-- Veritabanı: emrebayt_deneme

-- Kuaförler tablosu
CREATE TABLE IF NOT EXISTS kuaforler (
    id INT AUTO_INCREMENT PRIMARY KEY,
    isletme_adi VARCHAR(100) NOT NULL,
    subdomain VARCHAR(50) UNIQUE NOT NULL,
    sahip_adi VARCHAR(100) NOT NULL,
    telefon VARCHAR(20),
    email VARCHAR(100),
    adres TEXT,
    sehir VARCHAR(50),
    ilce VARCHAR(50),
    admin_username VARCHAR(50) NOT NULL,
    admin_password VARCHAR(255) NOT NULL,
    durum ENUM('aktif', 'pasif', 'beklemede') DEFAULT 'aktif',
    tema_renk VARCHAR(20) DEFAULT 'mavi',
    banner_resmi VARCHAR(255),
    karsilama_yazisi VARCHAR(255) DEFAULT 'Hoş Geldiniz',
    alt_yazi TEXT,
    seo_keywords TEXT,
    sosyal_medya TEXT,
    calisma_saatleri TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Stilistler tablosu
CREATE TABLE IF NOT EXISTS stilistler (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kuafor_id INT NOT NULL,
    isim_soyisim VARCHAR(100) NOT NULL,
    uzmanlik_alani VARCHAR(100),
    profil_resmi VARCHAR(255),
    username VARCHAR(50) NOT NULL,
    password VARCHAR(255) NOT NULL,
    durum ENUM('aktif', 'pasif') DEFAULT 'aktif',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE,
    UNIQUE KEY unique_username_per_kuafor (kuafor_id, username)
);

-- Hizmetler tablosu
CREATE TABLE IF NOT EXISTS hizmetler (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kuafor_id INT NOT NULL,
    hizmet_adi VARCHAR(100) NOT NULL,
    aciklama TEXT,
    resim VARCHAR(255),
    sure_dakika INT NOT NULL,
    fiyat DECIMAL(10,2) NOT NULL,
    anasayfa_goster BOOLEAN DEFAULT TRUE,
    sira_no INT DEFAULT 0,
    durum ENUM('aktif', 'pasif') DEFAULT 'aktif',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE
);

-- Randevular tablosu
CREATE TABLE IF NOT EXISTS randevular (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kuafor_id INT NOT NULL,
    stilist_id INT NOT NULL,
    musteri_adi VARCHAR(100) NOT NULL,
    musteri_telefon VARCHAR(20) NOT NULL,
    randevu_tarihi DATE NOT NULL,
    randevu_saati TIME NOT NULL,
    bitis_saati TIME NOT NULL,
    toplam_sure INT NOT NULL,
    toplam_fiyat DECIMAL(10,2) NOT NULL,
    durum ENUM('beklemede', 'onaylandi', 'tamamlandi', 'iptal') DEFAULT 'beklemede',
    notlar TEXT,
    okundu BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE,
    FOREIGN KEY (stilist_id) REFERENCES stilistler(id) ON DELETE CASCADE
);

-- Randevu hizmetleri tablosu (çoklu hizmet seçimi için)
CREATE TABLE IF NOT EXISTS randevu_hizmetleri (
    id INT AUTO_INCREMENT PRIMARY KEY,
    randevu_id INT NOT NULL,
    hizmet_id INT NOT NULL,
    hizmet_adi VARCHAR(100) NOT NULL,
    sure_dakika INT NOT NULL,
    fiyat DECIMAL(10,2) NOT NULL,
    FOREIGN KEY (randevu_id) REFERENCES randevular(id) ON DELETE CASCADE,
    FOREIGN KEY (hizmet_id) REFERENCES hizmetler(id) ON DELETE CASCADE
);

-- Müsaitlik yönetimi tablosu
CREATE TABLE IF NOT EXISTS musaitlik_yonetimi (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kuafor_id INT NOT NULL,
    stilist_id INT NULL, -- NULL ise tüm stilistler için
    baslangic_tarihi DATE NOT NULL,
    bitis_tarihi DATE NOT NULL,
    baslangic_saati TIME NULL, -- NULL ise tüm gün
    bitis_saati TIME NULL,
    sebep VARCHAR(255),
    durum ENUM('aktif', 'pasif') DEFAULT 'aktif',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE,
    FOREIGN KEY (stilist_id) REFERENCES stilistler(id) ON DELETE CASCADE
);

-- Destek talepleri tablosu
CREATE TABLE IF NOT EXISTS destek_talepleri (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kuafor_id INT NOT NULL,
    konu VARCHAR(255) NOT NULL,
    kategori ENUM('teknik', 'odeme', 'genel', 'acil') DEFAULT 'genel',
    oncelik ENUM('dusuk', 'orta', 'yuksek') DEFAULT 'orta',
    durum ENUM('acik', 'cevaplandi', 'cozuldu', 'kapali') DEFAULT 'acik',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE
);

-- Destek mesajları tablosu
CREATE TABLE IF NOT EXISTS destek_mesajlari (
    id INT AUTO_INCREMENT PRIMARY KEY,
    talep_id INT NOT NULL,
    gonderen_tip ENUM('kuafor', 'admin') NOT NULL,
    gonderen_id INT NOT NULL,
    mesaj TEXT NOT NULL,
    dosya_eki VARCHAR(255),
    okundu BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (talep_id) REFERENCES destek_talepleri(id) ON DELETE CASCADE
);

-- İletişim formları tablosu (ana site için)
CREATE TABLE IF NOT EXISTS iletisim_formlari (
    id INT AUTO_INCREMENT PRIMARY KEY,
    ad_soyad VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL,
    telefon VARCHAR(20),
    isletme_adi VARCHAR(100),
    sehir VARCHAR(50),
    mesaj TEXT NOT NULL,
    hizmet_turu SET('web_sitesi', 'randevu_sistemi', 'her_ikisi') NOT NULL,
    durum ENUM('yeni', 'okundu', 'cevaplandi') DEFAULT 'yeni',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Site ayarları tablosu (kuaför siteleri için)
CREATE TABLE IF NOT EXISTS site_ayarlari (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kuafor_id INT NOT NULL,
    ayar_adi VARCHAR(100) NOT NULL,
    ayar_degeri TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE CASCADE,
    UNIQUE KEY unique_setting_per_kuafor (kuafor_id, ayar_adi)
);

-- Ana site ayarları tablosu (tanıtım sitesi için)
CREATE TABLE IF NOT EXISTS ana_site_ayarlari (
    id INT AUTO_INCREMENT PRIMARY KEY,
    ayar_adi VARCHAR(100) UNIQUE NOT NULL,
    ayar_degeri TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Sistem logları tablosu
CREATE TABLE IF NOT EXISTS sistem_loglari (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kuafor_id INT NULL,
    islem_tipi VARCHAR(50) NOT NULL,
    aciklama TEXT NOT NULL,
    ip_adresi VARCHAR(45),
    user_agent TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (kuafor_id) REFERENCES kuaforler(id) ON DELETE SET NULL
);

-- Varsayılan veriler
INSERT INTO ana_site_ayarlari (ayar_adi, ayar_degeri) VALUES
('site_baslik', 'Kuaförünüz İçin Profesyonel Dijital Çözüm'),
('site_alt_baslik', 'Modern randevu sistemi + Şık web sitesi = Daha fazla müşteri'),
('hero_video', ''),
('ana_renk', 'mavi-turuncu'),
('hizmetler_aktif', '1'),
('portfoy_aktif', '1'),
('iletisim_aktif', '1');

-- İndeksler (install.php tarafından güvenli şekilde oluşturulacak)
-- CREATE INDEX idx_randevular_tarih ON randevular(randevu_tarihi);
-- CREATE INDEX idx_randevular_stilist ON randevular(stilist_id);
-- CREATE INDEX idx_randevular_durum ON randevular(durum);
-- CREATE INDEX idx_hizmetler_kuafor ON hizmetler(kuafor_id);
-- CREATE INDEX idx_stilistler_kuafor ON stilistler(kuafor_id);
-- CREATE INDEX idx_destek_durum ON destek_talepleri(durum);
-- CREATE INDEX idx_iletisim_durum ON iletisim_formlari(durum);
