<?php
/**
 * Kuaför Sistemi - cPanel API Konfigürasyonu
 * Otomatik subdomain oluşturma için
 */

class CpanelAPI {
    private $host = 'nahita.geneldns.com';
    private $port = '2083';
    private $username = 'emrebayt';
    private $api_token = 'H64F84O2I3FBWZ0ALGJ4Q91Y4JIJ46UG';
    private $domain = 'emrebaytas.com.tr';
    private $server_ip = '185.93.68.7';
    
    public function __construct() {
        // SSL doğrulamasını devre dışı bırak (shared hosting için)
        $this->context = stream_context_create([
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
            ],
        ]);
    }
    
    /**
     * Yeni subdomain oluştur
     */
    public function createSubdomain($subdomain) {
        $url = "https://{$this->host}:{$this->port}/execute/SubDomain/addsubdomain";
        
        $data = [
            'domain' => $subdomain,
            'rootdomain' => $this->domain,
            'dir' => "public_html/{$subdomain}"
        ];
        
        return $this->makeRequest($url, $data);
    }
    
    /**
     * Subdomain sil
     */
    public function deleteSubdomain($subdomain) {
        $url = "https://{$this->host}:{$this->port}/execute/SubDomain/delsubdomain";
        
        $data = [
            'domain' => "{$subdomain}.{$this->domain}"
        ];
        
        return $this->makeRequest($url, $data);
    }
    
    /**
     * Subdomain listesi
     */
    public function listSubdomains() {
        $url = "https://{$this->host}:{$this->port}/execute/SubDomain/listsubdomains";
        return $this->makeRequest($url);
    }
    
    /**
     * SSL sertifikası oluştur
     */
    public function createSSL($subdomain) {
        $url = "https://{$this->host}:{$this->port}/execute/SSL/install_ssl";
        
        $data = [
            'domain' => "{$subdomain}.{$this->domain}"
        ];
        
        return $this->makeRequest($url, $data);
    }
    
    /**
     * Klasör oluştur
     */
    public function createDirectory($path) {
        $url = "https://{$this->host}:{$this->port}/execute/Fileman/mkdir";
        
        $data = [
            'path' => "/home/{$this->username}/public_html/{$path}"
        ];
        
        return $this->makeRequest($url, $data);
    }
    
    /**
     * API isteği gönder
     */
    private function makeRequest($url, $data = []) {
        $headers = [
            "Authorization: cpanel {$this->username}:{$this->api_token}",
            "Content-Type: application/x-www-form-urlencoded"
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        
        if (!empty($data)) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        }
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);
        
        if ($error) {
            return [
                'success' => false,
                'error' => $error
            ];
        }
        
        $result = json_decode($response, true);
        
        return [
            'success' => $httpCode === 200,
            'data' => $result,
            'http_code' => $httpCode
        ];
    }
    
    /**
     * Subdomain kullanılabilirlik kontrolü
     */
    public function checkSubdomainAvailability($subdomain) {
        // Geçersiz karakterleri kontrol et
        if (!preg_match('/^[a-z0-9-]+$/', $subdomain)) {
            return [
                'available' => false,
                'error' => 'Subdomain sadece küçük harf, rakam ve tire içerebilir'
            ];
        }
        
        // Minimum uzunluk kontrolü
        if (strlen($subdomain) < 3) {
            return [
                'available' => false,
                'error' => 'Subdomain en az 3 karakter olmalıdır'
            ];
        }
        
        // Maksimum uzunluk kontrolü
        if (strlen($subdomain) > 20) {
            return [
                'available' => false,
                'error' => 'Subdomain en fazla 20 karakter olabilir'
            ];
        }
        
        // Yasaklı kelimeler
        $forbidden = ['www', 'mail', 'ftp', 'admin', 'api', 'test', 'demo', 'cpanel'];
        if (in_array($subdomain, $forbidden)) {
            return [
                'available' => false,
                'error' => 'Bu subdomain kullanılamaz'
            ];
        }
        
        // Mevcut subdomain'leri kontrol et
        $existing = $this->listSubdomains();
        if ($existing['success'] && isset($existing['data']['data'])) {
            foreach ($existing['data']['data'] as $sub) {
                if (isset($sub['domain']) && strpos($sub['domain'], $subdomain . '.') === 0) {
                    return [
                        'available' => false,
                        'error' => 'Bu subdomain zaten kullanılıyor'
                    ];
                }
            }
        }
        
        return [
            'available' => true,
            'subdomain' => $subdomain
        ];
    }
}
?>
