<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once __DIR__ . '/../config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Sadece POST metodu desteklenir']);
    exit;
}

try {
    // Form verilerini al ve temizle
    $ad_soyad = trim($_POST['ad_soyad'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $telefon = trim($_POST['telefon'] ?? '');
    $isletme_adi = trim($_POST['isletme_adi'] ?? '');
    $sehir = trim($_POST['sehir'] ?? '');
    $mesaj = trim($_POST['mesaj'] ?? '');
    $hizmet_turu = $_POST['hizmet_turu'] ?? [];
    
    // Zorunlu alanları kontrol et
    if (empty($ad_soyad)) {
        throw new Exception('Ad soyad alanı zorunludur');
    }
    
    if (empty($email)) {
        throw new Exception('E-posta alanı zorunludur');
    }
    
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        throw new Exception('Geçerli bir e-posta adresi giriniz');
    }
    
    if (empty($mesaj)) {
        throw new Exception('Mesaj alanı zorunludur');
    }
    
    if (empty($hizmet_turu)) {
        throw new Exception('En az bir hizmet türü seçiniz');
    }
    
    // Hizmet türlerini string'e çevir
    $hizmet_turu_str = implode(',', $hizmet_turu);
    
    // Veritabanına kaydet
    $db = Database::getInstance();
    $sql = "INSERT INTO iletisim_formlari (ad_soyad, email, telefon, isletme_adi, sehir, mesaj, hizmet_turu) 
            VALUES (?, ?, ?, ?, ?, ?, ?)";
    
    $params = [
        $ad_soyad,
        $email,
        $telefon,
        $isletme_adi,
        $sehir,
        $mesaj,
        $hizmet_turu_str
    ];
    
    $stmt = $db->query($sql, $params);
    
    if (!$stmt) {
        throw new Exception('Form gönderilirken bir hata oluştu');
    }
    
    // Başarılı yanıt
    echo json_encode([
        'success' => true,
        'message' => 'Mesajınız başarıyla gönderildi. En kısa sürede size dönüş yapacağız.'
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
