# 🚀 Kuaför Randevu ve Web Sitesi Sistemi

Kuaför ve berber salonları için profesyonel web sitesi ve randevu yönetim sistemi.

## 📋 Özellikler

### 🌟 Ana Tanıtım Sitesi
- Modern ve responsive tasarım
- Hizmet tanıtımları
- Portföy galerisi
- İletişim formu
- SEO optimizasyonu

### 💇‍♂️ Kuaför Yönetim Sistemi
- Otomatik subdomain oluşturma
- Randevu yönetimi
- Stilist yönetimi
- Hizmet yönetimi
- Müsaitlik kontrolü
- 50+ tema seçeneği

### 🎯 Super Admin Paneli
- Kuaför oluşturma ve yönetimi
- Destek sistemi
- İletişim form yönetimi
- Analitik raporlar
- cPanel API entegrasyonu

## 🛠️ Teknoloji Stack

- **Backend:** PHP 8.1+ (Vanilla PHP)
- **Frontend:** HTML5, CSS3, JavaScript, Tailwind CSS, Alpine.js
- **Veritabanı:** MySQL 5.7+
- **API:** cPanel UAPI
- **Hosting:** Shared hosting uyumlu

## 📦 Kurulum

### 1. Dosyaları Yükleyin
```bash
# Hosting'e kuafor-sistem klasörünü yükleyin
# Örnek: public_html/kuafor-sistem/
```

### 2. Veritabanı Ayarları
`config/database.php` dosyasındaki veritabanı bilgilerini güncelleyin:
```php
private $host = 'localhost';
private $dbname = 'emrebayt_deneme';
private $username = 'emrebayt_deneme';
private $password = 'Limonetea123!';
```

### 3. cPanel API Ayarları
`config/cpanel.php` dosyasındaki API bilgilerini güncelleyin:
```php
private $host = 'nahita.geneldns.com';
private $username = 'emrebayt';
private $api_token = 'H64F84O2I3FBWZ0ALGJ4Q91Y4JIJ46UG';
private $domain = 'emrebaytas.com.tr';
```

### 4. Veritabanı Kurulumu
Tarayıcıdan şu adrese gidin:
```
https://emrebaytas.com.tr/kuafor-sistem/database/install.php
```

### 5. DNS Ayarları
cPanel'de Zone Editor'dan wildcard DNS kaydı ekleyin:
```
Type: A
Name: *.emrebaytas.com.tr
Address: 185.93.68.7
```

## 🔗 Erişim Adresleri

### Ana Sistem
- **Ana Site:** https://emrebaytas.com.tr/kuafor-sistem/
- **Super Admin:** https://emrebaytas.com.tr/kuafor-sistem/xpanel/

### Demo Kuaför
- **Kuaför Sitesi:** https://demo.emrebaytas.com.tr/
- **Kuaför Admin:** https://demo.emrebaytas.com.tr/admin/
- **Giriş:** admin / 123456

## 📁 Proje Yapısı

```
kuafor-sistem/
├── config/
│   ├── database.php      # Veritabanı konfigürasyonu
│   └── cpanel.php        # cPanel API konfigürasyonu
├── classes/
│   └── Kuafor.php        # Kuaför yönetim sınıfı
├── database/
│   ├── schema.sql        # Veritabanı şeması
│   └── install.php       # Kurulum scripti
├── api/
│   └── contact.php       # İletişim formu API
├── admin/                # Super admin paneli
├── assets/               # CSS, JS, resimler
├── shared/               # Ortak dosyalar
└── index.php            # Ana sayfa
```

## 🎯 Kullanım

### Yeni Kuaför Oluşturma
1. Super admin paneline giriş yapın
2. "Yeni Kuaför" butonuna tıklayın
3. Gerekli bilgileri doldurun
4. Sistem otomatik olarak:
   - Subdomain oluşturur
   - Kuaför sitesini kurar
   - Varsayılan hizmetleri ekler
   - Admin kullanıcısı oluşturur

### Kuaför Yönetimi
- Randevu alma sistemi
- Stilist ekleme/düzenleme
- Hizmet yönetimi
- Site özelleştirme
- Müsaitlik ayarlama

## 🔧 Özelleştirme

### Tema Değiştirme
Kuaför admin panelinden 50+ tema arasından seçim yapabilirsiniz.

### SEO Ayarları
Sistem otomatik olarak şehir ve hizmet bazlı SEO anahtar kelimeleri oluşturur.

### Sosyal Medya
Instagram, Facebook, TikTok, YouTube entegrasyonu mevcuttur.

## 🛡️ Güvenlik

- SQL Injection koruması
- XSS koruması
- CSRF koruması
- Password hashing
- Input validation

## 📊 Veritabanı Tabloları

- `kuaforler` - Kuaför bilgileri
- `stilistler` - Stilist bilgileri
- `hizmetler` - Hizmet bilgileri
- `randevular` - Randevu kayıtları
- `randevu_hizmetleri` - Randevu-hizmet ilişkisi
- `musaitlik_yonetimi` - Müsaitlik ayarları
- `destek_talepleri` - Destek sistemi
- `destek_mesajlari` - Destek mesajları
- `iletisim_formlari` - İletişim form kayıtları
- `site_ayarlari` - Site ayarları
- `ana_site_ayarlari` - Ana site ayarları
- `sistem_loglari` - Sistem logları

## 🔄 API Endpoints

### İletişim Formu
```
POST /api/contact.php
```

### cPanel API
- Subdomain oluşturma
- Subdomain silme
- SSL sertifikası yönetimi
- Klasör oluşturma

## 🐛 Sorun Giderme

### Veritabanı Bağlantı Hatası
- `config/database.php` dosyasındaki bilgileri kontrol edin
- MySQL servisinin çalıştığından emin olun

### cPanel API Hatası
- API token'ın geçerli olduğunu kontrol edin
- Hosting'de cPanel API'nin aktif olduğunu kontrol edin

### Subdomain Oluşturamıyor
- Wildcard DNS kaydının doğru eklendiğini kontrol edin
- cPanel'de subdomain oluşturma yetkisinin olduğunu kontrol edin

## 📝 Geliştirme Notları

### Yeni Özellik Ekleme
1. Veritabanı değişiklikleri için `database/schema.sql` güncelleyin
2. Yeni sınıflar için `classes/` klasörünü kullanın
3. API endpoint'leri için `api/` klasörünü kullanın

### Tema Ekleme
1. CSS dosyalarını `assets/css/themes/` klasörüne ekleyin
2. Tema seçeneklerini veritabanına ekleyin

## 🤝 Katkıda Bulunma

1. Fork edin
2. Feature branch oluşturun
3. Değişikliklerinizi commit edin
4. Pull request gönderin

## 📄 Lisans

Bu proje Emre Baytaş tarafından geliştirilmiştir.

## 📞 İletişim

- **Web:** https://emrebaytas.com.tr
- **E-posta:** info@emrebaytas.com.tr

## 🎉 Teşekkürler

Bu projeyi kullandığınız için teşekkürler! Herhangi bir sorunuz varsa lütfen iletişime geçin.
